<?php

namespace App\Helpers;

use App\Models\RelatedViolations;
use App\Models\ViolationTitle;

use function PHPUnit\Framework\isEmpty;
use function PHPUnit\Framework\isNull;

class GradeViolationsHelper
{
    public static function violationTitles($violation_grade_id)
    {
        return ViolationTitle::with('violation_name')
            ->where('violation_grade_id', $violation_grade_id)
            ->get();
    }
    public static function get_violation_title_data($violation_title_id)
    {
        $data = [];
        $basic_punishments = ViolationTitle::with('punishments.namzeg', 'punishments.related_punishments')
        
        ->where('id', $violation_title_id)->get()
            ->flatMap(function ($violation_title) {
                return $violation_title->punishments->map(function ($punishment) {
                    $basic_namazeg = $punishment->namzeg;
                    $relative_basic_namazeg = $punishment->related_punishments->pluck('namzeg');
                    return [
                        "basic_namazeg" => $basic_namazeg,
                        "relative_basic_namazeg" => $relative_basic_namazeg,
                    ];
                });
            });
        $data['basic_punishments'] = $basic_punishments;

        $related_punishments = RelatedViolations::with('punishments')->where('relation_violation_titles_id', $violation_title_id)->get()
            ->groupBy('custom_name')
            ->map(function ($group) {
                return $group->map(function ($related_punishment) {
                    return [
                        'id' => $related_punishment->punishments->id,
                        'name' => $related_punishment->punishments->name,
                        'details' => $related_punishment->punishments->details,
                        'form_number' => $related_punishment->punishments->form_number,
                        'addition_related' => $related_punishment->addition_related,
                    ];
                });
            });

        $data['related_punishments'] = $related_punishments;
        return $data;
    }

    public static function get_admin_violation_title_data($violation_title_id)
    {
        $data = [];

        // Get basic punishments
        $basic_punishments = ViolationTitle::with('punishments.namzeg')
            ->where('id', $violation_title_id)
            ->get();
        $name_id = $basic_punishments->first()->name;
        $basic_punishments = $basic_punishments->flatMap(function ($violation_title) {
            return $violation_title->punishments->map(function ($punishment) {
                $basic_related_punishments = $punishment->related_punishments->map(function ($basic_related_punishment) {
                    return $basic_related_punishment->namzeg;
                });
                return ['namzeg' => $punishment->namzeg, 'value' => $punishment->value, 'basic_related_punishments' => $basic_related_punishments];
            });
        });

        $data['name_id'] = $name_id;
        $data['basic_punishments'] = $basic_punishments;

        // Get related punishments and group them by relation_violation_titles_id and custom_name
        $related_punishments = RelatedViolations::with('punishments')
            ->where('relation_violation_titles_id', $violation_title_id)
            ->get()
            ->groupBy(function ($item) {
                return $item->violation_titles_id . '|' . $item->custom_name;
            })
            ->map(function ($group, $key) {
                // Split the key into relation_violation_titles_id and custom_name
                [$real_violation_titles_id, $custom_name] = explode('|', $key);

                $punishments = $group->map(function ($related_punishment) {
                    return [
                        'id' => $related_punishment->punishments->id,
                        'name' => $related_punishment->punishments->name,
                        'details' => $related_punishment->punishments->details,
                        'form_number' => $related_punishment->punishments->form_number,
                        'addition_related' => $related_punishment->addition_related,
                    ];
                });
                return [
                    'relation_violation_titles_id' => (int)$real_violation_titles_id,
                    'custom_name' => $custom_name,
                    'punishments' => $punishments->toArray(),
                ];
            })
            ->values();

        $data['related_punishments'] = $related_punishments;

        return $data;
    }

    public static function get_violation_title_data_by_violation_name($violation_name_id, $violation_grade_id)
    {
        $basic_punishments = ViolationTitle::with('punishments.namzeg', 'punishments.related_punishments')
            ->where('violation_grade_id', $violation_grade_id)
            ->where('name', $violation_name_id)->get()
            ->flatMap(function ($violation_title) {
                return $violation_title->punishments->map(function ($punishment) {
                    $basic_namazeg = collect([$punishment->namzeg]);
                    $relative_basic_namazeg = $punishment->related_punishments->pluck('namzeg');
                    return $basic_namazeg->concat($relative_basic_namazeg)->values();
                });
            })->flatten(1)->values();
        $relation_violation_title = ViolationTitle::where('name', $violation_name_id)->first();
        $related_punishments = RelatedViolations::with('punishments')
            ->where('relation_violation_titles_id', $relation_violation_title->id)
            ->get() // Retrieve the collection before using map
            ->map(function ($group) {
                return [
                    'id' => $group->punishments->id,
                    'name' => $group->punishments->name,
                    'details' => $group->punishments->details,
                    'form_number' => $group->punishments->form_number,
                    'addition_related' => $group->addition_related,
                ];
            })->values();
        
        $punishments = $basic_punishments->concat($related_punishments);
        return $punishments;
    }

    // to get basic namazeg to select in first steps in store step 2
    public static function get_violation_namazeg_nessaccery_only($violation_title_id)
    {
        $data = [];
        $basic_punishments = ViolationTitle::with('punishments.namzeg', 'punishments.related_punishments')

        ->where('id', $violation_title_id)->get()
            ->flatMap(function ($violation_title) {
                return $violation_title->punishments->map(function ($punishment) {
                    $basic_namazeg = $punishment->namzeg;
                    return  $basic_namazeg;
                });
            });
        $data['basic_punishments'] = $basic_punishments;

        $related_punishments = RelatedViolations::with('punishments')->where('relation_violation_titles_id', $violation_title_id)->get()
            ->groupBy('custom_name')
            ->map(function ($group) {
                return $group->map(function ($related_punishment) {
                    return [
                        'id' => $related_punishment->punishments->id,
                        'name' => $related_punishment->punishments->name,
                        'details' => $related_punishment->punishments->details,
                        'form_number' => $related_punishment->punishments->form_number,
                        'addition_related' => $related_punishment->addition_related,
                    ];
                });
            });

        $data['related_punishments'] = $related_punishments;
        return $data;
    }
}
