<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegDepartmentProceduresFormRequest;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegDepartmentProceduresForm;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\Violations\ViolationStudentTitle;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg228Factory implements NamozegFactory
{
    // نموذج إجراءات إدارة التعليم (إشعار ولي الأمر)
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $student_id = ViolationStudentTitle::with('ViolationStudent')->where('id',$violation_student_punishment->violation_student_title_id)
        ->first()?->ViolationStudent?->student_id;

        $violation_grade = $violation_student_punishment->VStudentTitle->ViolationStudent->violationGrade;
        $violation_category = $violation_grade->violation_category;

        $namozeg = Namazeg::where('form_number', '228')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;

        $destructionProceed = new NamazegDepartmentProceduresFormRequest($request->all());
        $data = $destructionProceed->toArray();
        if ($data['date_type'] == 'hijri') {
            $data['date'] = Helper::getCoptic($data['date']);
        }
        unset($data['date_type']);
        NamazegDepartmentProceduresForm::create($data);
        if(in_array(3,$request->options)){
            StudentViolationDegrees::create([
                'violation_category_id' => $violation_category->id,
                'violation_grade_id' => $violation_grade->id,
                'student_id'=> $student_id,
                'namazeg_version_id'=> $namozeg_version->id,
                'bad_value'=> 15
            ]);
        }
        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $DepartmentProceduresFormRequest = new NamazegDepartmentProceduresFormRequest($request->all());
        $data = $DepartmentProceduresFormRequest->toArray();
        if ($data['date_type'] == 'hijri') {
            $data['date'] = Helper::getCoptic($data['date']);
        }
        unset($data['date_type']);
        $DepartmentProceduresForm = NamazegDepartmentProceduresForm::with('VStudentPunishment')->where('namazeg_version_id', $namozeg_version_id)->first();
        $student_id = $DepartmentProceduresForm->VStudentPunishment?->VStudentTitle?->ViolationStudent->student_id;
        $DepartmentProceduresForm->update($data);

        if (in_array(3, $request->options)) {
            StudentViolationDegrees::updateOrCreate(
                ['namazeg_version_id'=> $namozeg_version_id, 'student_id' => $student_id],
                ['bad_value'=> 15]
            );
        }elseif($DepartmentProceduresForm->degress){
            StudentViolationDegrees::where('namazeg_version_id', $namozeg_version_id)->delete();
        }
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $NamazegDepartmentProceduresForm = NamazegDepartmentProceduresForm::with('degress','namozegVersion', 'VStudentPunishment')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $student =$NamazegDepartmentProceduresForm->VStudentPunishment->VStudentTitle->ViolationStudent->student;
        $manager_name = SchoolEmployee::where('school_id', $student->school_id)->where('current_work_id', 1)->first()?->name;
        $school = School::findOrFail($student->school_id);
        $current_semester = Helper::getCurrentSchoolSemester();
        return [
            'form_number' => $NamazegDepartmentProceduresForm->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegDepartmentProceduresForm->namozegVersion->serial_number,
            'student_name' => $student->name,
            'current_school_year' => $school->current_school_year,
            'current_school' => $school->name,
            'current_semester' => $current_semester->name,
            'schoolClass' => $student->schoolClass->className->name,
            'decision_number' => $NamazegDepartmentProceduresForm->decision_number,
            'decision_day' =>   Carbon::createFromFormat('d/m/Y', $NamazegDepartmentProceduresForm->date)->translatedFormat('D', 'ar'),
            'decision_date' => Helper::getDateOptions($NamazegDepartmentProceduresForm->date, 'coptic'),
            'new_school_name' => $NamazegDepartmentProceduresForm->new_school_name,
            'options' => $NamazegDepartmentProceduresForm->options,
            'manager_name' => $manager_name,
            
        ];
    }
}
