<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegViolationInvitaionLetter;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg146Factory implements NamozegFactory
{
    //  محضر اثبات واقعه
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '145')->first();
        $date = $request->date_type == "hijri" ? Helper::getCoptic($request->date) : $request->date;
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        NamazegViolationInvitaionLetter::create([
            'v_student_punishment_id' => $violation_student_punishment->id,
            'namazeg_version_id' => $namozeg_version->id,
            'student_id' => $student_id,
            'date' => $date,
        ]);

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $date = $request->date_type == "hijri" ? Helper::getCoptic($request->date) : $request->date;

        NamazegViolationInvitaionLetter::where('namazeg_version_id', $namozeg_version_id)->update([
            'date' => $date,
        ]);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $NamazegViolationInvitaionLetter = NamazegViolationInvitaionLetter::with( 'namozegVersion', 'student')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $NamazegViolationInvitaionLetter->student->school;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        return [
            'form_number' => $NamazegViolationInvitaionLetter->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegViolationInvitaionLetter->namozegVersion->serial_number,
            'student_name' => $NamazegViolationInvitaionLetter->student->name,
            'class_name' => $NamazegViolationInvitaionLetter->student->schoolClass?->className?->name,
            'date' =>   $NamazegViolationInvitaionLetter->date,
            'day' =>   Carbon::createFromFormat('d/m/Y', $NamazegViolationInvitaionLetter->date)->translatedFormat('D', 'ar'),
            'manager_name' => $manager_name,
        ];
    }
}
