<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegViolationAccedentProceedRequest;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegViolationAccedentProceed;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeMember;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg145Factory implements NamozegFactory
{
    //  محضر اثبات واقعه
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '145')->first();
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        $destructionProceed  = new NamazegViolationAccedentProceedRequest($request->all());
        $data = $destructionProceed->toArray();
        NamazegViolationAccedentProceed::create($data);

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegViolationAccedentProceedRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        NamazegViolationAccedentProceed::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $NamazegViolationAccedentProceed = NamazegViolationAccedentProceed::with( 'namozegVersion', 'student')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $NamazegViolationAccedentProceed->student->school;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        $commite = Committee::with('members')->where('id', 2)->firstOrFail();
        $assignment = AssignmentCommittee::where('school_id', $school->id)
            ->where('committee_id',$commite->id)->firstOrFail();
        $members = CommitteeMember::with('employee')->where('assignment_committee_id', $assignment->id)->get();
        return [
            'form_number' => $NamazegViolationAccedentProceed->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegViolationAccedentProceed->namozegVersion->serial_number,
            'text' => $NamazegViolationAccedentProceed->text,
            'members' => $members->map(function ($member) {
                    return [
                        'employee_id' => $member->employee_id,
                        'employee_name' => $member->employee->name,
                        'assignment_work' => $member->assignment_work,
                        'current_work' => $member->employee->currentWork?->job_title,
                    ];
                }),
            'manager_name' => $manager_name,
        ];
    }
}
