<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegViolationProceed;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg143Factory implements NamozegFactory
{
    //محضر مخالفة سلوكية
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $date = $request->date_type == "hijri" ? Helper::getCoptic($request->date) : $request->date;
        $namozeg = Namazeg::where('form_number', '143')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegViolationProceed::create([
            'v_student_punishment_id' => $violation_student_punishment->id,
            'namazeg_version_id' => $namozeg_version->id,
            'date' => $date,
            'decision_number' => $request->decision_number,
            'about' => $request->about,
        ]);
        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $date = $request->date_type == "hijri" ? Helper::getCoptic($request->date) : $request->date;

        NamazegViolationProceed::where('namazeg_version_id', $namozeg_version_id)->update([
            'date' => $date,
            'decision_number' => $request->decision_number,
            'about' => $request->about,
        ]);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $NamazegViolationProceed = NamazegViolationProceed::with('namozegVersion', 'VStudentPunishment')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = School::with('educationDepartment')->where('id', $NamazegViolationProceed->VStudentPunishment->VStudentTitle->ViolationStudent->student->school_id)->first();
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $NamazegViolationProceed->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegViolationProceed->namozegVersion->serial_number,
            'educational_department_name' => $school->educationDepartment->name,
            'vioaltion_title' => $NamazegViolationProceed->VStudentPunishment->VStudentTitle->ViolationStudent->category?->name,
            'student_name' => $NamazegViolationProceed->VStudentPunishment->VStudentTitle->ViolationStudent->student->name,
            'schoolClass' => $NamazegViolationProceed->VStudentPunishment->VStudentTitle->ViolationStudent->student->schoolClass->className->name,
            'nationality' => $NamazegViolationProceed->VStudentPunishment->VStudentTitle->ViolationStudent->student->nationality,
            'ssn' => $NamazegViolationProceed->VStudentPunishment->VStudentTitle->ViolationStudent->student->ssn,
            'grade_name' => $NamazegViolationProceed->VStudentPunishment->VStudentTitle->ViolationStudent->violationGrade->name,
            'about' => $NamazegViolationProceed->about,
            'manager_name' => $manager_name,
            'decision_number' => $NamazegViolationProceed->decision_number,
            'date_option' => Helper::getDateOptions($NamazegViolationProceed->date, 'coptic'),
        ];
    }
}
