<?php

namespace App\Exports;

use App\Http\Resources\AdminDashboard\Finances\BankTransactionResource;
use App\Models\ManagerDashboard\Settings\Subscription;
use Carbon\Carbon;

use Maatwebsite\Excel\Concerns\FromCollection;


class BankTransactionExport implements FromCollection
{
    protected $startDate;
    protected $endDate;

    public function __construct($startDate = null, $endDate = null)
    {
        // Check if the start and end dates are provided and format them using Carbon
        $this->startDate = $startDate ? Carbon::createFromFormat('d/m/Y', $startDate)->format('Y-m-d H:i:s') : null;
        $this->endDate = $endDate ? Carbon::createFromFormat('d/m/Y', $endDate)->format('Y-m-d H:i:s') : null;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        // If both startDate and endDate are provided, filter by the date range
        if (!is_null($this->startDate) && !is_null($this->endDate)) {
            $subscriptions = Subscription::where('paid_type', 'bank_transfer')->whereBetween('created_at', [$this->startDate, $this->endDate])->get();
            return BankTransactionResource::collection($subscriptions);
        }

        // If no date range is provided, return all Subscription
        return BankTransactionResource::collection(Subscription::where('paid_type', 'bank_transfer')->get());
    }
}

