<?php

namespace App\Exceptions;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Database\QueryException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;

class Handler extends ExceptionHandler
{
    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });

        $this->renderable(function (NotFoundHttpException $e, $request) {
            if ($e->getPrevious() instanceof ModelNotFoundException) {
                return response()->json(['errors' => trans('api.no data found to this id')],404);
            }
        });
        $this->renderable(function (QueryException $e, $request) {
            return response()->json([
                'message' => trans('api.database_error'),
                'errors' => $e->getMessage(), // Optionally include the error message
            ], 404);
        });
        $this->renderable(function (ValidationException $e, $request) {
            return response()->json([
                'message' => trans('api.validation_error'),
                'errors' =>$e->errors(),
            ], 422);
        });

        $this->renderable(function (AuthenticationException $e, $request) {
            return response()->json(['errors' => trans('api.unauthenticated')], 401);
        });


        $this->renderable(function (JWTException $e, $request) {
            dd($e);
            return response()->json([
                'errors' => 'Token is invalid or has expired'
            ], 401);
        });



        // $this->renderable(function (\Exception $e, $request) {

        //     return response()->json(['message' => trans('api.Exception Error Found Try Again Later !')],500);
        // });

    }


}
