<?php

namespace App\Console;

use App\Helpers\HelperNotification;
use App\Services\DatabaseContext;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->call(function () {
        //     HelperNotification::create_manager_plan_notifications();
        // })->daily();
        // $schedule->command('inspire')->hourly();
        // $schedule->command('app:check-subscriptions-status')->daily();

         // Full backup every year on January 1st at midnight
        // $schedule->command('backup:create full')->yearlyOn(1, 1, '00:00');
        // Partial backup every six months (e.g., June 1st at midnight)
        // $schedule->command('backup:create partial')->yearlyOn(1, 1, '00:00');
        $schedule->command('backup:create full')->everyMinute();
        $schedule->call(function () {
            DatabaseContext::cleanupExpiredPreviews();
        })->daily();
        // $schedule->command('backup:create partial')->everyMinute();

    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
