<?php

namespace App\Console\Commands;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\AbsenseAndLateness\PeriodStudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedure;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLateness;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedure;
use App\Models\ManagerDashboard\Assignments\Assignment;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Assignments\AssignmentTeam;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use App\Models\ManagerDashboard\Backup;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeAlert;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeClassVisit;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate;
use App\Models\ManagerDashboard\Reports\ManagerReports\AdministrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\CommitteesMeeting;
use App\Models\ManagerDashboard\Reports\ManagerReports\SchoolStatusStatistic;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeWork;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeWork;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\Exams\NamazegPlans\DailyObservers\DailyObserves;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistributionAssignment;
use App\Models\ManagerDashboard\Exams\NamazegPlans\NamozegAnswerSheetProgress\AnswerSheetProgress;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration\TeacherCurriculumDeclaration;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignment;
use App\Models\ManagerDashboard\Messages\Message;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Supervisor;
use App\Models\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisit;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use App\Models\ManagerDashboard\TeacherSchedule;
use App\Models\ManagerDashboard\TeacherScheduleData;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use App\Models\ManagerDashboard\Violations\ViolationStudent;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceDescionConfirm;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegAcceptStudent;
use App\Models\ManagerDashboard\Namazeg\NamazegAssignProfessionalCommunities;
use App\Models\ManagerDashboard\Namazeg\NamazegBooksDelivery;
use App\Models\ManagerDashboard\Namazeg\NamazegChemistLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;
use App\Models\ManagerDashboard\Namazeg\NamazegClassPlanActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegDescionSumhoursLateleaving;
use App\Models\ManagerDashboard\Namazeg\NamazegEmployeeLeavingRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanImages;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanReport;
use App\Models\ManagerDashboard\Namazeg\NamazegExcessDamageRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentExcutionRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentsPlan;
use App\Models\ManagerDashboard\Namazeg\NamazegFinalReportClassActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegGuardianTransFrom;
use App\Models\ManagerDashboard\Namazeg\NamazegLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegMaintenanceForm;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\Namazeg\NamazegMonitoringLateAbsenceTeacher;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use App\Models\ManagerDashboard\Namazeg\NamazegQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegRecieptRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegSchoolCommitment;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentData;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherExcuse;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherPerformanceFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTransformQuranStudent;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\DbDumper\Databases\MySql;

class CreateBackup extends Command
{
    protected $signature = 'backup:create {type}'; // 'full' or 'partial'

    protected $description = 'Create a database Archive File (full or partial)';

    private $models = [
        // Students
        Student::class,
        // Teams and committees
        Team::class,
        Committee::class,
        // ClassRoomVisits
        ClassRoomVisitSession::class,
        // Exams
        DailyObserves::class,
        DistributionAssignment::class,
        AnswerSheetProgress::class,
        TeacherCurriculumDeclaration::class,
        TeacherQuestionAssignment::class,
        StudentCommittee::class,
        CorrectionAssignment::class,
        //attendance
        StudentAttendance::class,
        StudentLateness::class,
        PeriodStudentAttendance::class,
        StudentAbsenceProcedure::class,
        StudentLatenessProcedure::class,
        //violations
        ViolationStudent::class,
        // Offical Speeches
        Alert::class,
        Letter::class,
        // Tables
        ClassroomVisit::class,
        TableExam::class,
        ShiftTeacher::class,
        WaitingPeriodsSchedule::class,
        // Message 
        Message::class,
        // Reports
        EducationalAdminstrativeAlert::class,
        EducationalAdminstrativeClassVisit::class,
        EducationalAdminstrativeWork::class,
        AbsentLate::class,
        AdministrativeWork::class,
        CommitteesMeeting::class,
        SchoolStatusStatistic::class,
        SchoolAdminstrativeAbsentLate::class,
        SchoolAdminstrativeWork::class,
        StudentAdminstrativeAbsentLate::class,
        StudentAdminstrativeWork::class,
        // Namazeg
        StudentViolationDegrees::class,
        ViolationStudent::class,
        NamazegAbsenceDescionConfirm::class,
        NamazegAbsenceQuestioning::class,
        NamazegAcceptStudent::class,
        NamazegAssignProfessionalCommunities::class,
        NamazegBooksDelivery::class,
        NamazegChemistLabInventoryRecord::class,
        NamazegCircularAttendance::class,
        NamazegClassPlanActivity::class,
        NamazegDescionSumhoursLateleaving::class,
        NamazegEmployeeLeavingRecord::class,
        NamazegEvacuationPlanImages::class,
        NamazegEvacuationPlanReport::class,
        NamazegExcessDamageRecord::class,
        NamazegExpermentExcutionRecord::class,
        NamazegExpermentsPlan::class,
        NamazegFinalReportClassActivity::class,
        NamazegGuardianTransFrom::class,
        NamazegLabInventoryRecord::class,
        NamazegMaintenanceForm::class,
        NamazegManagerPlane::class,
        NamazegMonitoringLateAbsenceTeacher::class,
        NamazegNotifyLateLeaving::class,
        NamazegQuestioning::class,
        NamazegRecieptRecord::class,
        NamazegSchoolCommitment::class,
        NamazegStudentData::class,
        NamazegStudentFollow::class,
        NamazegTeacherExcuse::class,
        NamazegTeacherPerformanceFollow::class,
        NamazegTransformQuranStudent::class,
    ];

    public function handle()
    {
        $type = $this->argument('type');
        $fileName = $type == 'full' ?  'أرشيف النظام_' . now()->format('Y-m-d_H-i-s') : 'أرشيف غياب وتأخر منسوبي المدرسة_' . now()->format('Y-m-d_H-i-s');

        $backupDir = storage_path('app/backups');
        if (!file_exists($backupDir)) {
            mkdir($backupDir, 0777, true);  // Create the directory with the right permissions
        }

        MySql::create()
            ->setDbName(env('DB_DATABASE'))
            ->setUserName(env('DB_USERNAME'))
            ->setPassword(env('DB_PASSWORD'))
            ->setHost('127.0.0.1')  // Use TCP/IP instead of socket
            ->setPort(3306)          // Specify port if it's different from default
            ->dumpToFile(storage_path("app/backups/$fileName.sql"));

        Backup::create([
            'type' => $type,
            'name' => $fileName,
        ]);

        $this->info("{$type} backup created successfully: {$fileName}");

        // clean the existing data
        $this->SystemReset();
    }

    private function SystemReset()
    {
        // Employees
        // SchoolEmployee::where('current_work_id', '!=', 1)->withTrashed()->forceDelete();
        // Assignments
        Assignment::whereNotNull('school_id')->where('current_work_id', '!=', 1)->forceDelete();
        AssignmentCommittee::whereNotNull('school_id')->withTrashed()->forceDelete();
        AssignmentTeam::whereNotNull('school_id')->withTrashed()->forceDelete();
        GeneralAssignment::whereNotNull('school_id')->withTrashed()->forceDelete();
        // Tables
        $teacherScheduleIds = TeacherSchedule::pluck('id')->toArray();
        TeacherScheduleData::whereIn('teacher_schedule_id', $teacherScheduleIds)->forceDelete();
        $supervisionScheduleIds = SupervisionSchedul::withTrashed()->pluck('id')->toArray();
        Supervisor::whereIn('supervision_schedule_id', $supervisionScheduleIds)->forceDelete();

        // Clean The Rest Of Models
        foreach ($this->models as $model) {
            if (in_array(SoftDeletes::class, class_uses($model))) {
                $model::query()->withTrashed()->forceDelete();
            } else {
                $model::query()->forceDelete();
            }
        }
    }
}
