<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceSpecialtiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('service_specialties', function (Blueprint $table) {
            $table->id();
            $table->integer('service_id');
            $table->integer('specialty_id');
            $table->foreign('service_id')->references('id')
                 ->on('service_items');
            $table->foreign('specialty_id')->references('id')
                ->on('specialty_cats');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service_specialties');
    }
}
