<?php

namespace App\Http\Controllers\Branch\Cats;

use App\Http\Controllers\Controller;
use App\Models\Branch\Branch;
use App\Models\Branch\Oper_placecat as BranchOper_placecat;
use Illuminate\Http\Request;

class Oper_placecat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $oper_placecat = BranchOper_placecat::select('id', 'name', 'address')->get();
        return view('cats/oper_placecat.index', compact('oper_placecat'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/oper_placecat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:oper_placecats,name',
            'address' => 'required',
        ]);
        
        $oper_placecat = BranchOper_placecat::create([  
            'name' => $request->input('name'),
            'address' => $request->input('address'),
        ]);

        return redirect()->route('sett.oper_placecat.index')
            ->with('success', 'Operation place has created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $oper_placecat = BranchOper_placecat::find($id);
        return view('cats/oper_placecat.edit', compact('oper_placecat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
        ]);

        $oper_placecat = BranchOper_placecat::find($id);
        $oper_placecat->name = $request->input('name');
        $oper_placecat->address = $request->input('address');
        $oper_placecat->save();

        return redirect()->route('sett.oper_placecat.index')
            ->with('success', 'Operation Place has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
