<?php

namespace App\Http\Controllers;

use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\location\Country;
use App\Models\Patient\From_recourse;
use App\Models\Patient\Patient;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $id = Auth::id();

        $user_note = User::select('note')->find($id);

        $doctor_total = User::select('id')->count();

        $year = date('Y');
        $month = date('m');

        $patient_total = Patient::select('id')
            ->whereYear('created_at', '=', $year)
            ->whereMonth('created_at', '=', $month)
            ->where('type', 1);

        if (Auth::user()->branch_id !== 0) {
            $patient_total = $patient_total->where('first_branch_id', Auth::user()->branch_id);
        }

        $patient_total->count();


        $credit = Invoice::select('total_paid')
            ->whereYear('paid_date', '=', $year)
            ->whereMonth('paid_date', '=', $month)
            ->where('type', 0);

        if (Auth::user()->branch_id !== 0) {
            $credit = $credit->where('branch_id', Auth::user()->branch_id);
        }

        $credit = $credit->sum('total_paid');

        // ----------

        $creator_number_year = Appointment::select('creator_id')
            ->where('creator_id', $id)
            ->whereYear('created_at', '=', $year);

        if (Auth::user()->branch_id !== 0) {
            $creator_number_year = $creator_number_year->where('branch_id', Auth::user()->branch_id);
        }

        $creator_number_year = $creator_number_year->count('creator_id');

        $creator_number_month = Appointment::select('creator_id')
            ->where('creator_id', $id)
            ->whereYear('created_at', '=', $year)
            ->whereMonth('created_at', '=', $month);

        if (Auth::user()->branch_id !== 0) {
            $creator_number_month = $creator_number_month->where('branch_id', Auth::user()->branch_id);
        }
        $creator_number_month = $creator_number_month->count('creator_id');

        // ----------
        $doctor_number_year = Appointment::select('doctor_id')
            ->where('doctor_id', $id)
            ->whereYear('created_at', '=', $year);

        if (Auth::user()->branch_id !== 0) {
            $doctor_number_year = $doctor_number_year->where('branch_id', Auth::user()->branch_id);
        }
        $doctor_number_year = $doctor_number_year->count('doctor_id');


        $doctor_number_month = Appointment::select('doctor_id')
            ->where('doctor_id', $id)
            ->whereYear('created_at', '=', $year)
            ->whereMonth('created_at', '=', $month);

        if (Auth::user()->branch_id !== 0) {
            $doctor_number_month = $doctor_number_month->where('branch_id', Auth::user()->branch_id);
        }
        $doctor_number_month = $doctor_number_month->count('doctor_id');

        // ----------

        $debit = Invoice::select('total_paid')
            ->whereYear('paid_date', '=', $year)
            ->whereMonth('paid_date', '=', $month)
            ->where('type', 1);

        if (Auth::user()->branch_id !== 0) {
            $debit = $debit->where('branch_id', Auth::user()->branch_id);
        }
        $debit = $debit->sum('total_paid');

        // ----------

        $last_patient = Patient::select('id', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->orderBy('id', 'DESC')
            ->where('type', 1)
            ->limit(5);

        if (Auth::user()->branch_id !== 0) {
            $last_patient = $last_patient->where('first_branch_id', Auth::user()->branch_id);
        }
        $last_patient = $last_patient->get();

        // ----------

        $profit = Invoice_item::select('invoice_id', 'categorizable_id', 'categorizable_type', DB::raw('sum(paid) as sums'))
            ->whereHas('invoice', function ($q) {
                $q->where('type', 0)->select('id');
            })
            ->with(['categorizable' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('categorizable_id', 'categorizable_type')
            ->limit(11);

        if (Auth::user()->branch_id !== 0) {
            $profit = $profit->whereHas('invoice', function ($q) {
                $q->where('branch_id', Auth::user()->branch_id);
            });
        }

        $profit = $profit->get();

        // ----------

        $credit_stat = Invoice::select(
            DB::raw('sum(total_paid) as sums'),
            DB::raw("DATE_FORMAT(paid_date,'%m') as monthKey")
        )
            ->whereYear('paid_date', date('Y'))
            ->where('type', 0)
            ->groupBy('monthKey')
            ->orderBy('paid_date', 'ASC');

        if (Auth::user()->branch_id !== 0) {
            $credit_stat = $credit_stat->where('branch_id', Auth::user()->branch_id);
        }

        $credit_stat = $credit_stat->get();

        $debit_stat = Invoice::select(
            DB::raw('sum(total_paid) as sums'),
            DB::raw("DATE_FORMAT(paid_date,'%m') as monthKey")
        )
            ->whereYear('paid_date', date('Y'))
            ->where('type', 1)
            ->groupBy('monthKey')
            ->orderBy('paid_date', 'ASC');

        if (Auth::user()->branch_id !== 0) {
            $debit_stat = $debit_stat->where('branch_id', Auth::user()->branch_id);
        }

        $debit_stat = $debit_stat->get();

        $data_credit = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($credit_stat as $order) {
            $data_credit[$order->monthKey - 1] = $order->sums;
        }

        $data_debit = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

        foreach ($debit_stat as $order) {
            $data_debit[$order->monthKey - 1] = $order->sums;
        }

        // ----------

        $patient = Patient::select(
            DB::raw('count(id) as counts'),
            DB::raw("DATE_FORMAT(created_at,'%m') as monthKey")
        )
            ->whereYear('created_at', date('Y'))
            ->where('type', 1)
            ->groupBy('monthKey')
            ->orderBy('created_at', 'ASC');

        if (Auth::user()->branch_id !== 0) {
            $patient = $patient->where('first_branch_id', Auth::user()->branch_id);
        }
        $patient = $patient->get();

        $patient_date = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($patient as $order) {
            $patient_date[$order->monthKey - 1] = $order->counts;
        }

        // ----------

        $patient_total = Patient::whereYear('created_at', date('Y'))
            ->where('type', 1);

        if (Auth::user()->branch_id !== 0) {
            $patient_total = $patient_total->where('first_branch_id', Auth::user()->branch_id);
        }
        $patient_total = $patient_total->count();

        return view('dashboard', compact('user_note', 'doctor_total', 'patient_total', 'last_patient', 'credit', 'debit', 'profit', 'data_credit', 'data_debit', 'patient', 'patient_date', 'patient_total', 'creator_number_year', 'creator_number_month', 'doctor_number_year', 'doctor_number_month',));
    }
}