<?php $__env->startSection('title', 'Statistics | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Statistics'); ?>


<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">

        <span class="mb-0 me-1">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.appointment.index')); ?>"><?php echo e(__('basic.appointments')); ?> | </a>
            <a class="text-gray-300"><?php echo e(__('patientappo.appointment statistics')); ?></a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            <a class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-filter fa-sm me-1"></i> Filter</a>

            <!-- Modal for paying -->
            <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.app_allstatcs')); ?>" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                    Search Filter</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Specialty
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="specialty" name="specialty">
                                            <option value="all">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $specialty_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($specialty==$item->id): ?> selected <?php endif; ?>
                                                <?php if($specialty == $item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Branch
                                            <small>(optional)</small></label>
                                        <select class="myselect2-record-insert select2-hidden-accessible" id="branch"
                                            name="branch">
                                            <option value="all">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($branch==$item->id): ?> selected <?php endif; ?>
                                                <?php if($branch == $item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Status
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="status" name="status">
                                            <option value="all">
                                                All
                                            </option>
                                            <option value="0" <?php if($status==0): ?> selected <?php endif; ?>>
                                                <?php echo e(__('patientappo.not accepted')); ?>

                                            </option>
                                            <option value="1" <?php if($status==1): ?> selected <?php endif; ?>>
                                                <?php echo e(__('patientappo.accepted')); ?>

                                            </option>
                                            <option value="2" <?php if($status==2): ?> selected <?php endif; ?>>
                                                <?php echo e(__('patientappo.arrived')); ?>

                                            </option>
                                            <option value="3" <?php if($status==3): ?> selected <?php endif; ?>>
                                                <?php echo e(__('patientappo.with doctor')); ?>

                                            </option>
                                            <option value="4" <?php if($status==4): ?> selected <?php endif; ?>>
                                                <?php echo e(__('patientappo.done appointment')); ?>

                                            </option>
                                            <option value="5" <?php if($status==5): ?> selected <?php endif; ?>>
                                                <?php echo e(__('patientappo.not respond')); ?>

                                            </option>
                                            <option value="6" <?php if($status==6): ?> selected <?php endif; ?>>
                                                <?php echo e(__('patientappo.canceled')); ?>

                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Worker
                                            <small>(optional)</small></label>
                                        <select class="myselect2-record-insert select2-hidden-accessible" id="worker"
                                            name="worker">
                                            <option value="all">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($worker==$item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->first_name . ' ' . $item->second_name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">From
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="from" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($from); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">To
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="to" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($to); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>

    </div>


        <div class="row" >

            <div class="col-12" >
                <div class="card card-input shadow mb-3 pb-3">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-chart-bar me-1"></i>
                            <?php echo e(__('patientappo.appointment statistics')); ?></h6>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body" >

                        <ul class="nav nav-tabs mb-5" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="patient-tab" data-bs-toggle="tab"
                                    data-bs-target="#patient" type="button" role="tab" aria-controls="patient"
                                    aria-selected="true" class="text-gray-500"><i class="fas fa-user me-1"></i>
                                    <?php echo e(__('patientappo.total appointments')); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="country-tab" data-bs-toggle="tab" data-bs-target="#country"
                                    type="button" role="tab" aria-controls="country" aria-selected="false"
                                    class="main-color"><i class="fas fa-stethoscope me-1"></i>
                                    Specialty</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                                    type="button" role="tab" aria-controls="branches" aria-selected="false"
                                    class="main-color"><i class="fas fa-globe-americas me-1"></i>
                                    Branches</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="home-tab" data-bs-toggle="tab" data-bs-target="#home"
                                    type="button" role="tab" aria-controls="home" aria-selected="true"
                                    class="text-gray-500"><i class="fas fa-user me-1"></i>
                                    <?php echo e(__('patientappo.doctor creator')); ?></button>
                            </li>
                        </ul>

                        <div class="tab-content" id="myTabContent">


                            <div class="tab-pane fade show active" id="patient" role="tabpanel" aria-labelledby="patient">
                                <div class="dt-buttons btn-group flex-wrap ">
                                <button class="btn btn-table-export no-print me-0 buttons-print buttons-html5 rpt1" tabindex="0"
                                aria-controls="p-lab-table" type="button" onclick="print('totalAppo')"><span>Print</span></button>
                                <button class="btn btn-table-export no-print me-0 buttons-pdf buttons-html5" tabindex="0"
                                aria-controls="p-lab-table" type="button" onclick="exportPdf('totalAppo')"><span>PDF</span></button>
                                </div>
                                <div class="row mb-2 justify-content-center" id="totalAppo">

                                    <div class="col-12 mb-2">
                                        <div>
                                            <canvas id="myChart">
                                                <!-- the code and its style is printed from js -->
                                            </canvas>
                                        </div>
                                    </div>

                                    <div class="col-12 my-2 text-center">

                                        <h6 class="text-gray-400"><?php echo e(__('patientappo.total year appointment')); ?></h6>
                                        <span class="fs-1"><?php echo e($appointment_total); ?><small class="text-gray-300 text-xxxs">
                                                <?php echo e(__('basic.appointment')); ?></small></span>
                                    </div>

                                </div>

                            </div>

                            <div class="tab-pane fade" id="country" role="tabpanel" aria-labelledby="country-tab">
                                <div class="dt-buttons btn-group flex-wrap ">
                                <button class="btn btn-table-export no-print me-0 buttons-print buttons-html5 rpt1" tabindex="0"
                                aria-controls="p-lab-table" type="button" onclick="print('specialtyRpt')"><span>Print</span></button>
                                <button class="btn btn-table-export no-print me-0 buttons-pdf buttons-html5" tabindex="0"
                                aria-controls="p-lab-table" type="button" onclick="exportPdf('specialtyRpt')"><span>PDF</span></button>
                                </div>

                                <div class="row mb-2" id="specialtyRpt">
                                    <div class="col-12 col-md-6 border-flex">
                                        <h5 class="text-center text-gray-300">
                                            <?php echo e(__('patientappo.top speciality appo')); ?>

                                        </h5>
                                        <div class="chart-pie px-1 pb-3">
                                            <canvas id="speciality-chart">
                                                <!-- the code and its style is printed from js -->
                                            </canvas>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <h5 class="text-center text-gray-300">
                                            <?php if($from !== 'all'): ?>
                                            Top speicality in the given date
                                            <?php else: ?>
                                            <?php echo e(__('patientappo.top speciality appo month')); ?>

                                            <?php endif; ?>
                                        </h5>
                                        <div class="chart-pie px-1 pb-3">
                                            <canvas id="speciality-chart_month">
                                                <!-- the code and its style is printed from js -->
                                            </canvas>
                                        </div>

                                    </div>
                                </div>

                            </div>

                            <div class="tab-pane fade" id="branches" role="tabpanel" aria-labelledby="branches-tab">
                                <div class="dt-buttons btn-group flex-wrap ">
                                    <button class="btn btn-table-export no-print me-0 buttons-print buttons-html5 rpt1" tabindex="0"
                                    aria-controls="p-lab-table" type="button" onclick="print('branchRpt')"><span>Print</span></button>
                                    <button class="btn btn-table-export no-print me-0 buttons-pdf buttons-html5" tabindex="0"
                                    aria-controls="p-lab-table" type="button" onclick="exportPdf('branchRpt')"><span>PDF</span></button>
                                </div>
                                <div class="row mb-2" id="branchRpt">

                                    <div class="col-12 mb-5">
                                        <div>
                                            <canvas id="branches_line">
                                                <!-- the code and its style is printed from js -->
                                            </canvas>
                                        </div>
                                    </div>

                                    <div class="col-12 my-4 text-center">

                                        <div class="row">
                                            <div class="col-12 col-md-6 border-flex mb-2">
                                                <h5 class="text-center text-gray-300">
                                                    <?php echo e(__('patientappo.top branch appo')); ?>

                                                </h5>
                                                <div class="chart-pie px-1 pb-3">
                                                    <canvas id="branches-chart">
                                                        <!-- the code and its style is printed from js -->
                                                    </canvas>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <h5 class="text-center text-gray-300">
                                                    <?php if($from !== 'all'): ?>
                                                    Top branches in the given date
                                                    <?php else: ?>
                                                    <?php echo e(__('patientappo.top branch appo month')); ?>

                                                    <?php endif; ?>
                                                </h5>
                                                <div class="chart-pie px-1 pb-3">
                                                    <canvas id="branches-chart_month">
                                                        <!-- the code and its style is printed from js -->
                                                    </canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>


                            </div>

                            <div class="tab-pane fade" id="home" role="tabpanel" aria-labelledby="home-tab">
                                <div class="dt-buttons btn-group flex-wrap ">
                                    <button class="btn btn-table-export no-print me-0 buttons-print buttons-html5 rpt1" tabindex="0"
                                    aria-controls="p-lab-table" type="button" onclick="print('doctorRpt')"><span>Print</span></button>
                                    <button class="btn btn-table-export no-print me-0 buttons-pdf buttons-html5" tabindex="0"
                                    aria-controls="p-lab-table" type="button" onclick="exportPdf('doctorRpt')"><span>PDF</span></button>
                                </div>
                                <div id="doctorRpt">
                                    <div class="row">
                                        <div class="col-12 col-md-6 border-flex mb-3">
                                            <h5 class="text-center text-gray-300">
                                                <?php if($from !== 'all'): ?>
                                                Top doctors in the given date
                                                <?php else: ?>
                                                <?php echo e(__('patientappo.top doctors month')); ?>

                                                <?php endif; ?>
                                            </h5>
                                            <div class="chart-pie px-1 pb-3">
                                                <canvas id="myChart-doctor_responsible_month">
                                                    <!-- the code and its style is printed from js -->
                                                </canvas>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <h5 class="text-center text-gray-300">
                                                <?php if($from !== 'all'): ?>
                                                Top creators in the given date
                                                <?php else: ?>
                                                <?php echo e(__('patientappo.top creators month')); ?>

                                                <?php endif; ?>
                                            </h5>
                                            <div class="chart-pie px-1">
                                                <canvas id="myChart-creator_month">
                                                    <!-- the code and its style is printed from js -->
                                                </canvas>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row mb-3">
                                        <div class="col-12 col-md-6 border-flex mb-3">
                                            <h5 class="text-center text-gray-300"><?php echo e(__('patientappo.top doctors')); ?>

                                            </h5>
                                            <div class="chart-pie px-1 pb-3">
                                                <canvas id="myChart-doctor_responsible">
                                                    <!-- the code and its style is printed from js -->
                                                </canvas>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <h5 class="text-center text-gray-300"><?php echo e(__('patientappo.top creators')); ?>

                                            </h5>
                                            <div class="chart-pie px-1">
                                                <canvas id="myChart-creator">
                                                    <!-- the code and its style is printed from js -->
                                                </canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>

                        </div>

                    </div>
                </div>
            </div>


</div>
    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

    <script>
        function print(element) {
            printJS( element , 'html')
        }
        function exportPdf(element) {
            var Pelement = document.getElementById(element);
                    var opt = {
                    margin:       1,
                    filename:     'report.pdf',
                    image:        { type: 'jpeg', quality: 0.98 },
                    html2canvas:  { scale: 2 ,scrollY: 0,scrollX: 0},
                    jsPDF:        { unit: 'in', format: 'a1', orientation: 'p' }
                    };
                    html2pdf().set(opt).from(Pelement).save();
        }
    </script>
    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

                $(".myselect2-record-insert").select2({
                    dropdownParent: $("#new_record")
                });

                //hide search
                $('.myselect2-record-insert-nosearch').select2({
                    dropdownParent: $("#new_record"),
                    minimumResultsForSearch: -1
                });

            })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months",
                    autoclose: true,
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    <?php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2', '#dc3545', '#51b24b', '#a94bb2', '#4b8bb2', '#57b24b', '#a5b24b', '#b2804b', '#b24b4b',
    '#834bb2', '#b24b6a', '#574bb2', '#236368', '#232c68', '#682345', '#4b2368', '#234b68', '#306823', '#a39f39',
    '#a239a3', '#a33963', '#a33951', '#a33939', '#c73737', '#6837c7'];
    ?>

    <script>
        // Area Chart for all branches
            var ctx = document.getElementById("myChart");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [{
                        label: "Appointment",
                        lineTension: 0.5,
                        backgroundColor: "#1cc88a",
                        borderColor: "#1cc88a",
                        pointRadius: 3,
                        pointBackgroundColor: "#1cc88a",
                        pointBorderColor: "#1cc88a",
                        pointHoverRadius: 3,
                        pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                        pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                        pointHitRadius: 10,
                        pointBorderWidth: 2,
                        data: [
                            <?php $__currentLoopData = $appointment_date; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }, ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });

            // Area Chart for each branch
            var ctx = document.getElementById("branches_line");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [
                        <?php
                            $i = 0;
                        ?>
                        <?php $__currentLoopData = $appointment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            {
                                label: "<?php echo e($item->name); ?>",
                                lineTension: 0.5,
                                backgroundColor: '<?php echo e($chart_color[$i]); ?>',
                                borderColor: '<?php echo e($chart_color[$i]); ?>',
                                pointRadius: 3,
                                pointBackgroundColor: '<?php echo e($chart_color[$i]); ?>',
                                pointBorderColor: '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                                pointHoverRadius: 3,
                                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                                pointHitRadius: 10,
                                pointBorderWidth: 2,
                                data: [
                                    <?php $__currentLoopData = $item->total; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item4): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($item4 . ','); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                ],
                            },
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: true
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });
    </script>

    <script>
        // ---------  doctor responsible chart year ---------
            var ctx_recourse = document.getElementById("myChart-doctor_responsible");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $doctor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->doctor): ?>
                                "<?php echo e($item->doctor->name); ?>"
                            <?php else: ?>
                                "No doctor"
                            <?php endif; ?> ,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $doctor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $doctor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- creator chart year ---------
            var ctx_recourse = document.getElementById("myChart-creator");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $creator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->creator->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $creator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $creator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- doctor responsible chart month ---------
            var ctx_recourse = document.getElementById("myChart-doctor_responsible_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $doctor_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->doctor): ?>
                                "<?php echo e($item->doctor->name); ?>"
                            <?php else: ?>
                                "No doctor"
                            <?php endif; ?> ,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $doctor_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $doctor_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- creator chart month ---------
            var ctx_recourse = document.getElementById("myChart-creator_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $creator_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->creator->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $creator_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $creator_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>


    <script>
        // --------- specialty chart month ---------
            var ctx_recourse = document.getElementById("speciality-chart");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $specialty_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->specialty->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $specialty_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $specialty_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- specialty month chart month ---------
            var ctx_recourse = document.getElementById("speciality-chart_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $specialty_order_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->specialty->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $specialty_order_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $specialty_order_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- specialty chart month ---------
            var ctx_recourse = document.getElementById("branches-chart");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $branch_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $branch_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $branch_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- specialty month chart month ---------
            var ctx_recourse = document.getElementById("branches-chart_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $branch_order_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $branch_order_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $branch_order_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/branch/appointment/allstatcs.blade.php ENDPATH**/ ?>