<?php $__env->startSection('title', 'Login | Proxima - Medical Management app'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- google recaptcha -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="video_intro_log">
        <div style="position: relative; overflow: hidden; padding-top: 56.25%;"><iframe
                src="https://share.synthesia.io/embeds/videos/08600113-eb38-4da2-9c2e-94d3aaad89e2" loading="lazy"
                title="Synthesia video player - Your AI video" allow="encrypted-media; fullscreen;"
                style="position: absolute; width: 100%; height: 100%; top: 0; left: 0; border: none; padding: 0; margin: 0; overflow:hidden;"></iframe>
        </div>
    </div>


    <div class="login_body" style="background-image: url('<?php echo e(asset('img/dashboard/system/doctor-lab.jpg')); ?>');">

        <div class="overlay-dark1"></div>

        <div class="container-fluid px-3 px-md-5">

            <!-- Outer Row -->
            <div class="row justify-content-center min-vh-100 align-content-center position-relative">
                <div class="col-12 col-md-6 col-lg-7 align-self-center">
                    <div class="row">
                        <div class="col-12 px-1 px-md-5 mb-2 mb-md-4 pt-3 pt-md-0 text-center text-md-start">
                            <svg class="me-2 border-end border-light pe-3 pb-3" viewBox="25.719 19.652 225.906 121.613"
                                xmlns="http://www.w3.org/2000/svg" width="160px">
                                <text
                                    style="fill: rgb(255, 255, 255); font-family: Arial, sans-serif; font-size: 65px; font-weight: 700; letter-spacing: -5.1px; white-space: pre;"
                                    x="25.734" y="124.092">Proxima</text>
                                <text
                                    style="fill: rgb(255, 255, 255); font-family: Arial, sans-serif; font-size: 10px; white-space: pre;"
                                    x="29.252" y="139.145">Tomorrow is Brighter</text>
                                <path
                                    d="M 171.934 41.222 L 147.195 20.607 C 144.541 18.403 140.431 20.245 140.431 23.776 L 140.431 65.006 C 140.431 68.537 144.541 70.392 147.195 68.176 L 171.934 47.561 C 173.904 45.912 173.904 42.871 171.934 41.222 Z M 138.949 41.222 L 114.211 20.607 C 111.557 18.403 107.447 20.245 107.447 23.776 L 107.447 65.006 C 107.447 68.537 111.557 70.392 114.211 68.176 L 138.949 47.561 C 140.921 45.912 140.921 42.871 138.949 41.222 Z"
                                    style="fill: rgb(255, 255, 255);" />
                            </svg>
                            <img src="<?php echo e(asset('img/dashboard/system/pc-loader-white.png')); ?>">
                        </div>
                        <div class="col-12 px-5 d-none d-md-block ">
                            <h1 class="text-white fw-bold text-xl"><?php echo e(__('basic.login msg head 1')); ?> <span
                                    class="fw-light fs-1"> <?php echo e(__('basic.login msg line 1')); ?></span> </h1>

                        </div>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-5 mb-4 mb-md-0">
                    <div class="card overflow-hidden border-0 shadow-lg">
                        <div class="card-body p-0">
                            <!-- Nested Row within Card Body -->
                            <div class="p-5">
                                <div class="text-center">
                                    <h1 class="h4 text-gray-900 mb-2"><?php echo e(__('basic.welcome back')); ?></h1>
                                </div>

                                <div class="row">
                                    <div class="d-flex justify-content-center">
                                        <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="me-2 <?php if(LaravelLocalization::getCurrentLocaleNative() == $properties['native']): ?> text-gray-500
                                                <?php else: ?>
                                                    text-gray-300 <?php endif; ?>"
                                                rel="alternate" hreflang="<?php echo e($localeCode); ?>"
                                                href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>">
                                                <?php echo e($properties['native']); ?>

                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>

                                <form id="myform" method="POST" action="<?php echo e(route('sett.login')); ?>">
                                    <?php echo csrf_field(); ?>

                                    <div class="cont_tap">
                                        <label for="password"
                                            class="col-md-4 col-form-label text-md-right"><?php echo e(__('patientappo.phone number')); ?></label>
                                        <input id="identify" name="identify" type="text"
                                            class="form-control form-control-user <?php $__errorArgs = ['identify'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="exampleInputEmail" value="<?php echo e(old('identify')); ?>" required
                                            autocomplete="identify" autofocus placeholder="Enter your Mobile or Email...">

                                        <?php $__errorArgs = ['identify'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        <?php if(count($errors) && in_array(__('auth.throttle'), $errors->get('identify'))): ?>
                                            <p><?php echo app('translator')->get('auth.throttle'); ?></p>
                                            <button>Close</button>
                                            <button>Contact</button>
                                        <?php endif; ?>
                                        <div class="d-flex justify-content-end mt-3">
                                            <input type="button" name="next" class="next-form-steps next-email btn btn-primary action-button-next"
                                                value="Continue" />
                                        </div>
                                    </div>
                                    <div class="cont_tap">
                                        <div class="col-12  mb-2">
                                            <label class="form-label"><?php echo e(__('basic.branch')); ?> <small><?php echo e(__('basic.required')); ?></small></label>
                                            <select class="js-example-basic-single select2-no-search select2-hidden-accessible"
                                                name="branch" required>

                                            </select>
                                        </div>
                                        <div class="d-flex justify-content-end mt-3">
                                                <input type="button" name="next" class="next-form-steps btn btn-primary action-button-next"
                                                    value="Continue" />
                                        </div>
                                    </div>
                                    <div class="cont_tap">
                                        <div class="form-group">
                                            <label for="password"
                                                class="col-md-4 col-form-label text-md-right"><?php echo e(__('patientappo.password')); ?></label>

                                            <input name="password" type="password"
                                                class="form-control form-control-user <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="password" placeholder="Password" required autocomplete="current-password">

                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="d-flex text-center mb-2">
                                            <div class="g-recaptcha" id="feedback-recaptcha"
                                                data-sitekey="<?php echo e(env('GOOGLE_RECAPTCHA_KEY')); ?>"></div>
                                        </div>

                                        <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox small">
                                                <input type="checkbox" class="custom-control-input-user" name="remember"
                                                    id="remember" id="customCheck" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                                <label class="custom-control-label-user"
                                                    for="remember"><?php echo e(__('basic.remember me')); ?></label>
                                            </div>
                                        </div>

                                        <button type="submit" class="btn btn-primary btn-user col-12">
                                            <?php echo e(__('basic.login')); ?>

                                        </button>

                                        <hr>
                                        <button href="index.html" class="btn btn-google btn-user col-12 mb-2">
                                            <i class="fab fa-google fa-fw"></i> Login with Google
                                        </button>
                                        <button href="index.html" class="btn btn-facebook btn-user col-12">
                                            <i class="fab fa-facebook-f fa-fw"></i> Login with Facebook
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>

    </div>
<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>
<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
</script>
    <!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {

                email: {
                    email: true,
                },
                password: {
                    maxlength: 100,
                },

            },
            messages: {
                email: {
                    required: "We need your email address",
                    email: "Your email address must be in the format of name@domain.com"
                },

            },

        });
</script>
<script>
    $(document).on("click", ".next-form-steps", function() {
        if(!$(this).data("skip")){
            //for validation
            $('#myform').validate();
            if (!$('#myform').valid()) {

                return false;
            }
        }

        //
        current_fs = $(this).closest(".cont_tap");
        next_fs = $(this).closest(".cont_tap").next();

        //Add Class (Active) and (checked) progress bar
        $("#progressbar li").eq($(".cont_tap").index(next_fs)).addClass("active");
        //eq() is to select an element with a specific index number.
        $("#progressbar li .icon-circle").eq($(".cont_tap").index(next_fs)).addClass("checked");

        //show the next div
        next_fs.show();

        //hide the current div with style
        current_fs.animate({ opacity: 0 }, {
            step: function (now) {
                // for making the div appear animation
                opacity = 1 - now;
                current_fs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                next_fs.css({ 'opacity': opacity });
            },
            duration: 500
        });
    });
    $('.next-email').click(async (event)=>{
        let email = $('input[name="identify"]').val();
        let branches = await fetch_branches(email);
        $.each(branches, function(key, value) {
            $('select[name="branch"]').append('<option value="' +
            value.id + '">' + value.name + '</option>');
        });
    })
    async function fetch_branches(email) {
        let url = "<?php echo e(route('app_fetch_users_branches_ajax')); ?>";
                try {
                    const response = await $.ajax({
                    url
                    , type: "POST"
                    ,data: {
                            '_token': "<?php echo e(csrf_token()); ?>",
                            'email': email,
                        }
                    });
                    return response;

                } catch (error) {
                    console.error("Error occurred:", error);
                    throw error;
                }
        }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.normmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/auth/login.blade.php ENDPATH**/ ?>