

<?php $__env->startSection('title', 'Debtors | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Worker'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

<?php $__env->stopSection(); ?>



<?php $__env->startSection('fixedcontent'); ?>

<div id="add_buttn_fixed">
    <a data-bs-toggle="modal" data-bs-target="#new_record" class="text-white">
        <i class="fas fa-plus"></i>
    </a>
</div>

<!-- session successful message -->
<?php if(Session::has('success')): ?>
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">
        <span class="mb-0 me-1">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
            <a class="text-gray-300">Doctor result</a>
        </span>

        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Hr')): ?>
        <div class="d-flex justify-content-center">
            <a class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-plus fa-sm me-1"></i> New Recored</a>
        </div>

        <!-- Modal for paying -->
        <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                            New record</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <form class="mb-0" action="<?php echo e(route('sett.hr_create_doctor_record', $doctor->id)); ?>" method="POST">

                        <?php echo csrf_field(); ?>

                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <div class="row">

                                <div class="col-12 mb-2">
                                    <label class="form-label">Type
                                        <small>(required)</small></label>
                                    <select
                                        class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="type" name="type" required>
                                        <option value="0">Fine</option>
                                        <option value="1">Bonus</option>
                                        <option value="2">Promotion</option>
                                        <option value="3">Problem</option>
                                        <option value="4">Other</option>
                                    </select>

                                    <span id="type_error" class="error-msg-form"></span>

                                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-msg-form">
                                        <?php echo e($message); ?>

                                    </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div class="col-12 mb-2">
                                    <label class="form-label">Start
                                        <small>(required)</small></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                            </div>
                                        </div>
                                        <input name="start" type="text" class="form-control hasdatetimepicker "
                                            placeholder="YYYY/MM/DD" required="">
                                        <input name="doctor_id" type="hidden" value="<?php echo e($doctor->id); ?>">
                                    </div>
                                    <span id="start_error" class="error-msg-form"></span>

                                    <?php $__errorArgs = ['start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-msg-form">
                                        <?php echo e($message); ?>

                                    </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 mb-2">
                                    <label class="form-label">Amount
                                        <small>(optional)</small></label>
                                    <input name="amount" type="number" class="form-control"
                                        placeholder="Write here the amount ..">
                                    <span id="amount_error" class="error-msg-form"></span>

                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-msg-form">
                                        <?php echo e($message); ?>

                                    </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-12 mb-2">
                                    <label class="form-label">Note
                                        <small>(optional)</small></label>
                                    <textarea name="note" class="form-control " placeholder="Write here your note .."
                                        rows="4" spellcheck="false"></textarea>
                                    <span id="note_error" class="error-msg-form"></span>

                                    <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-msg-form">
                                        <?php echo e($message); ?>

                                    </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                    Mind</button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link main-color">Send</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>

        </div>
        <?php endif; ?>


    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-stethoscope me-1"></i> Doctor result</h6>
        </div>


        <!-- Card Body -->
        <div class="card-body px-4 px-md-5">

            <div class="row px-0 px-md-3 px-lg-5 pt-3">

                <div class="col-8 col-md-6">

                    <div class="row mb-2">
                        <div class="d-flex align-items-center">
                            <img class="rounded-circle avatar-lg me-3"
                                src="<?php echo e(URL::asset('img/useravatar/' . $doctor->avatar)); ?>">
                            <div class="text-truncate">
                                <p class=" mb-0 text-xs text-gray-300">
                                    <?php echo e($doctor->getRoleNames()[0]); ?></p>
                                <a class="mb-1 fw-bold fs-5 text-gray-600 text-truncate"><?php echo e($doctor->name); ?></a>
                                <p class="mb-0 text-xs text-gray-400">ID <strong>
                                        <?php echo e($doctor->id); ?></strong>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-4 col-md-2 align-self-center">
                    <div class="">
                        <h6 class="text-gray-300 text-xs mb-1">Branch</h6>
                        <p id="addre_final_info" class="text-gray-600 fs-6 fw-bold mb-0">
                            <?php if($doctor->branch): ?>
                            <?php echo e($doctor->branch->name); ?>

                            <?php else: ?>
                            All
                            <?php endif; ?>
                        </p>
                    </div>
                </div>

                <div class="col-6 col-md-2 align-self-center">
                    <div class="">
                        <h6 class="text-gray-300 text-xs mb-1">Phone</h6>
                        <p id="addre_final_info" class="text-gray-600 fs-6 fw-bold mb-0">
                            <?php echo e($doctor->phone_number); ?>

                        </p>
                    </div>
                </div>

                <div class="col-6 col-md-2 align-self-center">
                    <div class=" main-color-bg text-center b-r-s-cont p-2">
                        <h6 class="text-blue-300 text-xs mb-1"><i class="far fa-star"></i> Rate</h6>
                        <p id="addre_final_info" class="text-white fs-4 fw-bold mb-0">
                            <?php echo e(round($rate, 2)); ?> <small class="text-xs text-blue-300">/ 5</small>
                        </p>
                    </div>
                </div>

            </div>

            <hr>



            <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="doctor_records-tab" data-bs-toggle="tab"
                        data-bs-target="#doctor_records" type="button" role="tab" aria-controls="doctor_records"
                        aria-selected="true" class="text-gray-500"><i class="fas fa-users me-1"></i>
                        Records</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="payment-tab" data-bs-toggle="tab" data-bs-target="#payment"
                        type="button" role="tab" aria-controls="payment" aria-selected="true" class="text-gray-500"><i
                            class="fas fa-wallet me-1"></i>
                        Payment</button>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="<?php echo e(route('sett.hr_attendance', $doctor->id)); ?>">
                        <button class="nav-link" id="payment-tab" data-bs-toggle="tab" type="button" role="tab"
                            aria-controls="payment" aria-selected="true" class="text-gray-500"><i
                                class="fas fa-person-booth me-1"></i>
                            Attendence</button>
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="<?php echo e(route('sett.doctor_profile_comm_service_month', $doctor->id)); ?>">
                        <button class="nav-link" id="payment-tab" data-bs-toggle="tab" type="button" role="tab"
                            aria-controls="payment" aria-selected="true" class="text-gray-500"><i
                                class="fas fa-money-check-alt me-1"></i>
                            Commission</button>
                    </a>
                </li>
            </ul>

            <div class="tab-content" id="myTabContent">

                <div class="tab-pane fade show active" id="doctor_records" role="tabpanel"
                    aria-labelledby="doctor_records">

                    <ul class="list-group patient-timeline">

                        <?php $__currentLoopData = $doctor_record; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->type == 0): ?>
                        <?php
                        $type_text = 'Fine';
                        $text_color = 'cancel-color';
                        ?>
                        <?php elseif($item->type == 1): ?>
                        <?php
                        $type_text = 'Bonus';
                        $text_color = 'done-color';
                        ?>
                        <?php elseif($item->type == 2): ?>
                        <?php
                        $type_text = 'Promotion';
                        $text_color = 'done-color';
                        ?>
                        <?php elseif($item->type == 3): ?>
                        <?php
                        $type_text = 'Problem';
                        $text_color = 'cancel-color';
                        ?>
                        <?php elseif($item->type == 4): ?>
                        <?php
                        $type_text = 'Other';
                        $text_color = 'main-color';
                        ?>
                        <?php endif; ?>

                        <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">

                            <i class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                            <div class="col-4 me-1">
                                <p class="text-xs text-gray-400 mb-0">
                                    <?php echo e(date('d M Y', strtotime($item->start))); ?></p>
                                <h6 class="text-s fw-bold  mb-0"><?php echo e($type_text); ?></h6>
                            </div>

                            <div class="col-6 align-self-center me-1">
                                <p class="text-xs text-gray-200 mb-0">Note</p>
                                <h6 class="text-s text-gray-400 pe-2"> <?php echo e($item->note); ?>

                                </h6>
                            </div>

                            <div class="col-2 align-self-center me-1">
                                <p class="text-xs text-gray-200 mb-0">Price</p>
                                <h6 class="text-s text-gray-400"> <?php echo e($item->amount); ?>

                                </h6>
                            </div>

                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">

                            <i class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 main-color"
                                style="top: 21px;"></i>

                            <div class="col me-1">
                                <p class="text-xs text-gray-400 mb-0">
                                    <?php echo e(date('d M Y', strtotime($doctor->started_work))); ?></p>
                                <h6 class="text-s fw-bold mb-0">Started Wokring</h6>
                            </div>
                        </li>

                    </ul>

                </div>

                <div class="tab-pane fade" id="payment" role="tabpanel" aria-labelledby="payment-tab">
                    <div class="row px-0 my-4">

                        <div class="col-12">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-debitor" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs">Name</th>
                                            <th class="text-xs text-center">Branch</th>
                                            <th class="text-xs text-center">Amount</th>
                                            <th class="text-xs text-center">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $invoice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->status == 0): ?>
                                        <?php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = 'Not Paid';
                                        ?>
                                        <?php elseif($item->status == 1): ?>
                                        <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = 'Pending';
                                        ?>
                                        <?php elseif($item->status == 2): ?>
                                        <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = 'Paid';
                                        ?>
                                        <?php endif; ?>

                                        <tr>
                                            <td class="text-truncate"><a class="text-gray-600"
                                                    href="<?php echo e(route('sett.invoice.show', $item->id)); ?>">
                                                    <?php echo e($item->code); ?></a>
                                            </td>

                                            <td class="text-center">
                                                <?php echo e($item->branch->name); ?>

                                            </td>

                                            <td class="text-center">
                                                <?php if(!empty($item->paid)): ?>
                                                <?php echo e($item->paid); ?> <small class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                                <?php endif; ?>
                                            </td>

                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                            </td>


                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>

                        </div>

                    </div>
                </div>

            </div>

        </div>


    </div>

</div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>
<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {


            $(".myselect2-record-insert").select2({
                dropdownParent: $("#new_record")
            });

            //hide search
            $('.myselect2-record-insert-nosearch').select2({
                dropdownParent: $("#new_record"),
                minimumResultsForSearch: -1
            });

        })
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
</script>

<!-- -- datatables plugin -- -->
<script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>


<script>
    $(document).ready(function() {

            var table = $('#table-debitor').DataTable({
                    lengthChange: false,
                    "pageLength": 5,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-debitor_wrapper .col-md-6:eq(0)');

        });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/invoice/doctor_debt.blade.php ENDPATH**/ ?>