<!---------- Lab results --------->
<div class="col-12 col-lg-4">
    <div class="card shadow mb-4">

        <div id="lab-operation" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#lab-operation" data-bs-slide-to=" 0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#lab-operation" data-bs-slide-to=" 1"
                    aria-label="Slide 2"></button>
                <button type="button" data-bs-target="#lab-operation" data-bs-slide-to="2"
                    aria-label="Slide 3"></button>
            </div>

            <div class="carousel-inner">

                <!-- Current treatments -->
                <div class="carousel-item active">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('patientappo.lab results')
                                }}</span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="1" aria-label="Slide 2">
                                {{ __('basic.operations') }}</span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="2" aria-label="Slide 3">
                                {{ __('basic.attachments') }}</span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#adddxـray">{{ __('patientappo.new lab') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    @if (!$patient->labs->isEmpty())
                    <div class="card-body pb-2">
                        <div class="list-group">
                            @foreach ($patient->labs as $item)
                            {{-- blade-formatter-disable-next-line --}}
                            @break($loop->index === 3)
                            @if ($item->invoice_item)
                            @if ($item->invoice_item->invoice->status == 0)
                            <div
                                class="list-group-item li-gr-it-no-space-flx justify-content-between align-items-center mb-3">
                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xs mb-0">
                                        {{ date('d M Y', strtotime($item->created_at)) }}</p>
                                    <a href="{{ route('sett.lab.show', $item->id) }}"
                                        class="text-xs link-cust-text text-gray-500 text-truncate"><i
                                            class="fas fa-file-medical-alt text-gray-300 me-1 text-truncate"></i>
                                        {{ $item->service_item->name }}</a>
                                </div>

                                <div>
                                    <span class="badge rounded-pill cancel-color-btn badge-padd-l">{{ __('basic.not
                                        paid') }}</span>
                                </div>
                            </div>
                            @else
                            @if ($item->status == 0)
                            @php
                            $lab_status_btn = '<span
                                class="badge rounded-pill active-color-btn badge-padd-l">Sent</span>';
                            $lab_href = '';
                            @endphp
                            @else
                            @php
                            $lab_status_btn = '<i class="fas fa-arrow-circle-down text-m"></i>';
                            $lab_href = 'href="' . URL::asset('img/lab/' . $item->xray_file) . '"';
                            @endphp
                            @endif

                            <div
                                class="list-group-item li-gr-it-no-space-flx justify-content-between align-items-center mb-2">
                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xs mb-0">
                                        {{ date('d M Y', strtotime($item->created_at)) }}</p>
                                    <a href="{{ route('sett.lab.show', $item->id) }}"
                                        class="text-xs link-cust-text text-gray-500 text-truncate"><i
                                            class="fas fa-file-medical-alt text-gray-300 me-1 text-truncate"></i>
                                        {{ $item->service_item->name }}</a>
                                </div>

                                <div>
                                    <a class="text-gray-400" @php echo $lab_href @endphp>
                                        @php echo $lab_status_btn @endphp
                                    </a>
                                </div>
                            </div>
                            @endif
                            @endif
                            @endforeach
                        </div>
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-iteam stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#adddxـray">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">You can put your notes</p>
                        </a>
                    </div>
                    @endif

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#lab_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>
                </div>

                <!----------- operation comperation start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('basic.operations')
                                }}</span>
                            <span
                                class="m-0 text-x link-cust-text me-2 text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="2" aria-label="Slide 3">
                                {{ __('basic.attachments') }}</span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="0" aria-label="Slide 1">
                                {{ __('patientappo.lab results') }}</span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_operation">{{ __('patientappo.new operation') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    @if (!$patient->operations->isEmpty())
                    <div id="medicine_card_home" class="card-body align-items-center">

                        @foreach ($patient->operations as $item)
                        {{-- blade-formatter-disable-next-line --}}
                        @break($loop->index === 3)

                        @if ($item->status == 0)
                        @php
                        $text_color = 'not_accepted-color';
                        $msg = __('patientappo.not scheduled');
                        @endphp
                        @elseif ($item->status == 1)
                        @php
                        $text_color = 'main-color';
                        $msg = __('patientappo.scheduled');
                        @endphp
                        @elseif ($item->status == 2)
                        @php
                        $text_color = 'arrived-color';
                        $msg = __('patientappo.accepted');
                        @endphp
                        @elseif ($item->status == 3)
                        @php
                        $text_color = 'done-color';
                        $msg = __('patientappo.done');
                        @endphp
                        @elseif ($item->status == 4)
                        @php
                        $text_color = 'notresp-color';
                        $msg = __('patientappo.not respond');
                        @endphp
                        @elseif ($item->status == 5)
                        @php
                        $text_color = 'inprog-color';
                        $msg = __('patientappo.postponed');
                        @endphp
                        @elseif ($item->status == 6)
                        @php
                        $text_color = 'cancel-color';
                        $msg = __('patientappo.canceled');
                        @endphp
                        @endif

                        @if ($item->invoice_item)
                        @if ($item->invoice_item->invoice->status == 0)
                        @php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.not paid');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 1)
                        @php
                        $text_color_invoice = 'pend-color-btn';
                        $msg_invoice = __('basic.pending');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 2)
                        @php
                        $text_color_invoice = 'prog-color-btn';
                        $msg_invoice = __('basic.installment');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 3)
                        @php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('basic.paid');
                        @endphp
                        @elseif ($item->invoice_item->invoice->status == 4)
                        @php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.refund');
                        @endphp
                        @endif
                        @else
                        @php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('patientappo.old record');
                        @endphp
                        @endif
                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 {{ $text_color }}"></i>

                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xxs mb-0">
                                        {{ date('h:i a d M Y', strtotime($item->start_at)) }}</p>
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        @if ($item->service_item)
                                        {{ $item->service_item->name }}
                                        @else
                                        Deleted Service
                                        @endif
                                    </p>
                                    <p class="text-xs text-gray-300 fw-bold mb-0">{{ $msg }}</p>
                                </div>
                            </div>

                            <span class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{ $msg_invoice
                                }}</span>

                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#add_operation">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">{{ __('patientappo.new operation') }}</p>
                        </a>
                    </div>

                    @endif

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#operations_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>
                </div>

                <!----------- attatchment comperation start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('basic.attachments')
                                }}</span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="1" aria-label="Slide 1">
                                {{ __('basic.operations') }}</span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="0" aria-label="Slide 0">
                                {{ __('patientappo.lab results') }}</span>

                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_attachment">{{ __('basic.new attachment') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    @if (!$patient->attachments->isEmpty())
                    <div id="medicine_card_home" class="card-body align-items-center">

                        @foreach ($patient->attachments as $item)
                        {{-- blade-formatter-disable-next-line --}}
                        @break($loop->index === 3)

                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-image me-2 fs-4 mb-0 {{ $item->name }}"></i>

                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xxs mb-0">
                                        {{ $item->date }}</p>
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        {{ $item->name }}
                                    </p>
                                </div>
                            </div>

                            <a href="{{ URL::asset('img/pat_attachments/' . $item->img) }}" target="_blank">
                                <span class="badge rounded-pill main-color-btn badge-padd-l">{{ __('basic.download')
                                    }}</span>
                            </a>

                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#add_attachment">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">{{ __('basic.new attachment') }}</p>
                        </a>
                    </div>

                    @endif

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#attachment_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal show all lab -->
    <div class="modal fade" id="lab_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-x-ray me-1"></i>
                        {{ __('patientappo.lab results') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-lab" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs">{{ __('basic.name') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.code') }}</th>
                                    <th class="text-xs text-center">{{ __('patientappo.pay status') }}</th>
                                    <th class="text-xs text-center">{{ __('patientappo.pay Code') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.status') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.note') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.created') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.handle') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($patient->labs as $item)
                                @if ($item->status == 0)
                                @php
                                $text_color = 'active-color-btn';
                                $msg = __('basic.sent');
                                @endphp
                                @elseif ($item->status == 1)
                                @php
                                $text_color = 'done-color-btn';
                                $msg = __('patientappo.done');
                                @endphp
                                @endif
                                @if ($item->invoice_item)
                                @if ($item->invoice_item->invoice->status == 0)
                                @php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.not paid');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 1)
                                @php
                                $text_color_invoice = 'pend-color-btn';
                                $msg_invoice = __('basic.pending');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 2)
                                @php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 3)
                                @php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.paid');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 4)
                                @php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.refund');
                                @endphp
                                @endif
                                @else
                                @php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('patientappo.old lab');
                                @endphp
                                @endif

                                <tr>
                                    <td><a href="{{ route('sett.lab.show', $item->id) }}"
                                            class="link-cust-text text-gray-500 text-truncate"><i
                                                class="fas fa-file-medical-alt link-cust-text text-gray-300 me-1 text-truncate"></i>
                                            {{ $item->service_item->name }}
                                        </a></td>
                                    <td class="text-center">{{ $item->code }}</td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{
                                            $msg_invoice }}</span>
                                    </td>
                                    <td class="text-center">
                                        @if ($item->invoice_item)
                                        {{ @$item->invoice_item->invoice->code }}
                                        @else
                                        No Payment
                                        @endif
                                    </td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg }}</span>
                                    </td>
                                    <td>{{ $item->note_lab }}</td>

                                    <td class="text-center">
                                        {{ date('d M Y', strtotime($item->created_at)) }}
                                    </td>

                                    <td class="text-center">

                                        @if (!empty($item->xray_file))
                                        <a href="{{ URL::asset('img/lab/' . $item->xray_file) }}" target="_blank"
                                            class="btn btn-sm modal-effect status-col-link active-color-btn b-r-xs mb-1"
                                            title="download"><i class="fas fa-arrow-circle-down"></i>
                                            {{ __('basic.download') }}
                                        </a>
                                        @endif
                                        @if ($item->invoice_item)
                                        @if ($item->invoice_item->invoice->status == 0)
                                        <a data-lab_id="{{ $item->id }}"
                                            data-invoice_id="{{ $item->invoice_item->invoice->id }}"
                                            class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 lab_delete_click"
                                            title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                            data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                            {{ __('basic.delete') }}
                                        </a>
                                        @endif
                                        @endif

                                    </td>

                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                            __('basic.never mind') }}</button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="button" class="btn btn-default btn-link main-color">{{ __('basic.save changes')
                            }}</button>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <!-- Modal lab insert data -->
    <div class="modal fade" id="adddxـray" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="{{ route('sett.lab_patient_add') }}" method="post" style="display: contents">
                {{ method_field('POST') }}
                {{ csrf_field() }}

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-x-ray me-1"></i>
                            {{ __('patientappo.new lab') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('patientappo.lab catagory') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-lab-insert select2-hidden-accessible @error('lab_cat_serv_id') is-invalid @enderror"
                                    id="lab_cat_serv_id" name="lab_cat_serv_id" required>
                                    @foreach ($service_cat_lab as $item)
                                    <option value="{{ $item->id }}" data-price="{{ $item->price }}">
                                        {{ $item->name . ' - ' . $item->price . 'EGP' }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="lab_cat_serv_id_error" class="error-msg-form"></span>

                                @error('lab_cat_serv_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>


                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.note') }}
                                    <small>({{ __('basic.optional') }})</small></label>

                                <textarea name="note_doctor_lab"
                                    class="form-control @error('note_doctor_lab') is-invalid @enderror"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="note_doctor_lab_error" class="error-msg-form"></span>

                                @error('note_doctor_lab')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <hr class="my-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.appointment') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-lab-insert-nosearch select2-hidden-accessible @error('last_appointment_id') is-invalid @enderror"
                                    id="last_appointment_id_lab" name="last_appointment_id" required>
                                    @foreach ($patient->appointments as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->start_at }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="last_appointment_id_error" class="error-msg-form"></span>

                                @error('last_appointment_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.invoice') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-lab-insert-nosearch @error('lab_cat_invoice') is-invalid @enderror"
                                    id="lab_cat_invoice_insert" name="lab_cat_invoice" required>
                                    <option value="new">New Invoice</option>
                                    @foreach ($patient->invoices as $item)
                                    @if ($item->status == 0)
                                    <option value="{{ $item->id }}">
                                        {{ $item->service_inv_cat->name . ' - ' . $item->final_price . 'EGP' }}
                                    </option>
                                    @endif
                                    @endforeach
                                </select>

                                <span id="lab_cat_invoice_error" class="error-msg-form"></span>

                                @error('lab_cat_invoice')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.invoice note') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <textarea name="invoice_note_lab" class="form-control"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                @error('invoice_note_lab')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                        </div>

                        <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal lab delete -->
    <div class="modal fade" id="lab_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.lab.destroy', 'test') }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                X-Ray?</p><br>
                            <input type="hidden" name="lab_id_delete" value="">
                            <input type="hidden" name="lab_invoice_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!-- Modal show all operations -->
    <div class="modal fade" id="operations_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                        {{ __('basic.operations') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    @foreach ($patient->operations as $item)
                    @if ($item->status == 0)
                    @php
                    $text_color = 'not_accepted-color-btn';
                    $msg = __('patientappo.not scheduled');
                    @endphp
                    @elseif ($item->status == 1)
                    @php
                    $text_color = 'main-color-btn';
                    $msg = __('patientappo.scheduled');
                    @endphp
                    @elseif ($item->status == 2)
                    @php
                    $text_color = 'active-color-btn';
                    $msg = __('patientappo.accepted');
                    @endphp
                    @elseif ($item->status == 3)
                    @php
                    $text_color = 'done-color-btn';
                    $msg = __('patientappo.with doctor');
                    $msg = __('patientappo.done');
                    @endphp
                    @elseif ($item->status == 4)
                    @php
                    $text_color = 'pend-color-btn';
                    $msg = __('patientappo.not respond');
                    @endphp
                    @elseif ($item->status == 5)
                    @php
                    $text_color = 'prog-color-btn';
                    $msg = __('patientappo.postponed');
                    @endphp
                    @elseif ($item->status == 6)
                    @php
                    $text_color = 'cancel-color-btn';
                    $msg = __('patientappo.canceled');
                    @endphp
                    @endif

                    @if ($item->invoice_item)
                    @if ($item->invoice_item->invoice->status == 0)
                    @php
                    $text_color_invoice = 'cancel-color-btn';
                    $msg_invoice = __('basic.not paid');
                    @endphp
                    @elseif ($item->invoice_item->invoice->status == 1)
                    @php
                    $text_color_invoice = 'pend-color-btn';
                    $msg_invoice = __('basic.pending');
                    @endphp
                    @elseif ($item->invoice_item->invoice->status == 2)
                    @php
                    $text_color_invoice = 'prog-color-btn';
                    $msg_invoice = __('basic.installment');
                    @endphp
                    @elseif ($item->invoice_item->invoice->status == 3)
                    @php
                    $text_color_invoice = 'done-color-btn';
                    $msg_invoice = __('basic.paid');
                    @endphp
                    @elseif ($item->invoice_item->invoice->status == 4)
                    @php
                    $text_color_invoice = 'cancel-color-btn';
                    $msg_invoice = __('basic.refund');
                    @endphp
                    @endif
                    @php
                    $invoice_id_operation = route('sett.invoice.show', $item->invoice_item->invoice->id);
                    @endphp
                    @else
                    @php
                    $msg_invoice = 'Old Appointment';
                    $text_color_invoice = 'done-color-btn';
                    $invoice_id_operation = '';
                    @endphp
                    @endif

                    <div class="p-2">

                        <div class="row mb-2">
                            <div class="col-6 col-md-3">
                                <div class="d-flex">
                                    <i class="fas fs-1 fa-procedures me-2 align-self-center text-gray-400"></i>
                                    <div>
                                        <p class="text-xxs mb-0 text-gray-300">
                                            {{ date('h:i a Y-m-d', strtotime($item->start_at)) }}</p>
                                        <h6 class="mb-0 fw-bold">
                                            @if ($item->service_item)
                                            {{ $item->service_item->name }}
                                            @else
                                            Deleted Service
                                            @endif
                                        </h6>
                                        <p class="text-xxs mb-0 text-gray-300">Op place: {{ $item->place->name }}
                                            @isset($item->doctor->first_name)
                                            with
                                            docotr <span class="fw-bold">{{ $item->doctor->first_name }}</span>
                                            @endisset
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-md-3 text-center align-self-center">
                                <p class="text-xs text-gray-200 mb-1">Status</p>
                                <h6 class="text-s text-gray-400 text-truncate">
                                    <span class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg }}</span>
                                </h6>
                            </div>
                            <div class="col-4 col-md-2 text-center align-self-center">
                                <p class="text-xs text-gray-200 mb-1">Payment</p>
                                <h6 class="text-s text-gray-400 text-truncate">
                                    <a href="{{ $invoice_id_operation }}"><span
                                            class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{
                                            $msg_invoice }}</span></a>
                                </h6>
                            </div>
                            <div class="col-4 col-md-2 text-center align-self-center">
                                <p class="text-xs text-gray-200 mb-0">Improvment Rate</p>
                                @if ($item->improvement_rate)
                                <span class="text-gray-400">{{ $item->improvement_rate }}</span>
                                @else
                                <span class="text-gray-400">Not selected</span>
                                @endif
                            </div>

                            <div class="col-4 col-md-2 text-center align-self-center">
                                <a data-operation_id="{{ $item->id }}" data-status_operation="{{ $item->status }}"
                                    data-note_operation="{{ $item->note }}"
                                    data-improvement_rate="{{ $item->improvement_rate }}"
                                    class="btn rounded-pill btn-sm status-col-link active-color-btn b-r-xs operation_edit_click px-4"
                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                    {{ __('basic.edit') }} </a>

                                @if ($item->invoice_item)
                                @if ($item->invoice_item->invoice->status == 0)
                                <a data-operation_id="{{ $item->id }}"
                                    class="btn rounded-pill btn-sm status-col-link active-color-btn b-r-xs cancel-color-btn b-r-xs mt-1 px-4 operation_delete_click"
                                    title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                    data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                    {{ __('basic.delete') }}
                                </a>
                                @endif
                                @endif

                            </div>
                        </div>

                        <div class="accordion accordion-100" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingSpec">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseStat" aria-expanded="true"
                                        aria-controls="collapseStat">
                                        <i class="fas fa-x-ray me-1"></i> {{ __('patientappo.pre op') }}
                                    </button>
                                </h2>
                                <div id="collapseStat" class="accordion-collapse collapse show"
                                    aria-labelledby="headingSpec" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="d-flex justify-content-between add_exam_modal" data-type="op"
                                            data-id="{{ $item->id }}">
                                            <p class="text-gray-300">Here is all info before the operation</p>
                                            <div class="clickable-item-pointer">
                                                <p><i class="fas fa-plus"></i>
                                                    @if ($item->pre_op_draw)
                                                    Update
                                                    @else
                                                    Add New
                                                    @endif
                                                </p>
                                            </div>
                                        </div>

                                        <div class="d-flex flex-wrap justify-content-center">
                                            <div class="mb-3 mb-md-0"
                                                style="background-image: url('{{ asset('img/dashboard/system/human_front.jpg') }}'); width:255px; height:457px; position: relative;">
                                                @if (!empty($item->pre_op_draw->front))
                                                <img src="{{ URL::asset('img/diseasedraw/' . $item->pre_op_draw->front) }}"
                                                    width="255" height="457"
                                                    style=" solid;position: absolute;top:0;left:0;">
                                                @else
                                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                                    {{ __('patientappo.no back draw') }}
                                                </div>
                                                @endif
                                            </div>
                                            <div class="mb-3 mb-md-0"
                                                style="background-image: url('{{ asset('img/dashboard/system/human_back.jpg') }}'); width:255px; height:457px; position: relative;">

                                                @if (!empty($item->pre_op_draw->back))
                                                <img src="{{ URL::asset('img/diseasedraw/' . $item->pre_op_draw->back) }}"
                                                    width="255" height="457"
                                                    style=" solid;position: absolute;top:0;left:0;">
                                                @else
                                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                                    {{ __('patientappo.no front draw') }}
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="mb-2">
                                            <label class="form-label mb-1">{{ __('patientappo.examination note')
                                                }}:</label>
                                            <div class="form-control-textarea overflow-auto"
                                                style="border-radius: 13px !important; border: 1px solid #d5d5d5;">
                                                @if (!empty($item->pre_op_draw->note))
                                                {{ $item->pre_op_draw->note }}
                                                @else
                                                No Note
                                                @endif
                                            </div>
                                        </div>

                                        <div class="table-responsive">
                                            <table class="table display datatable-modal" id="table-disease" width="100%"
                                                cellspacing="0">
                                                <thead>
                                                    <tr>
                                                        <th class="text-xs w-25">{{ __('basic.name') }}
                                                        </th>
                                                        <th class="text-xs text-center">
                                                            {{ __('basic.start') }}</th>
                                                        <th class="text-xs text-center">
                                                            {{ __('basic.end') }}</th>
                                                        <th class="text-xs text-center">
                                                            {{ __('basic.status') }}</th>
                                                        <th class="text-xs text-center">
                                                            {{ __('basic.handle') }}</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($item->diseases as $item_des)
                                                    @if ($item_des->status == 0)
                                                    @php
                                                    $text_color = 'active-color-btn';
                                                    $msg = __('patientappo.still');
                                                    @endphp
                                                    @elseif ($item_des->status == 1)
                                                    @php
                                                    $text_color = 'done-color-btn';
                                                    $msg = __('patientappo.healed');
                                                    @endphp
                                                    @endif

                                                    <tr>
                                                        <td class="w-25">
                                                            {{ $item_des->diseasecats->name }}</td>
                                                        <td>{{ $item_des->start }}</td>
                                                        <td class="text-center">{{ $item_des->end }}
                                                        </td>
                                                        <td class="text-center"> <span
                                                                class="badge rounded-pill {{ $text_color }} badge-padd-l">{{
                                                                $msg }}</span>
                                                        </td>

                                                        <td class="text-center">
                                                            <a data-disease_id="{{ $item_des->id }}"
                                                                data-diseasecats_id="{{ $item_des->diseasecats->id }}"
                                                                data-status_disease="{{ $item_des->status }}"
                                                                data-start="{{ $item_des->start }}"
                                                                data-end="{{ $item_des->end }}"
                                                                class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 disease_edit_click"
                                                                title="edit"><i class="fas fa-pencil-alt"></i>
                                                                {{ __('basic.edit') }} </a>

                                                            <a data-disease_id="{{ $item_des->id }}"
                                                                class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 disease_delete_click"
                                                                title="delete" data-effect="effect-scale"><i
                                                                    class="fas fa-trash"></i>
                                                                {{ __('basic.delete') }}
                                                            </a>

                                                        </td>

                                                    </tr>
                                                    @endforeach

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="duringop-accor">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseReco" aria-expanded="true"
                                        aria-controls="collapseReco">
                                        <i class="fas fa-pager me-1"></i> {{ __('patientappo.during op') }}
                                    </button>
                                </h2>
                                <div id="collapseReco" class="accordion-collapse collapse"
                                    aria-labelledby="duringop-accor" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">

                                        @if ($item->during_op)
                                        <form class="mb-0" action="{{ route('sett.operation_patient_during_op_upd') }}"
                                            method="POST">
                                            @csrf
                                            @method('PUT')

                                            <div class="row mb-2 text-gray-700">

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum (Hump
                                                            Reduction Bony)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->dorsum_hump_reduction_bony)
                                                            checked @endif name="dorsum_hump_reduction_bony"
                                                            type="checkbox" value="1"
                                                            id="dorsum_hump_reduction_bony_up"><label
                                                                for="dorsum_hump_reduction_bony_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('dorsum_hump_reduction_bony')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum
                                                            (Hump
                                                            Reduction Septal)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->dorsum_hump_reduction_septal)
                                                            checked @endif
                                                            name="dorsum_hump_reduction_septal"
                                                            type="checkbox" value="1"
                                                            id="dorsum_hump_reduction_septal_up"><label
                                                                for="dorsum_hump_reduction_septal_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('dorsum_hump_reduction_septal')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum (Hump
                                                            Reduction Cartilaginous)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->dorsum_hump_reduction_cartilaginous)
                                                            checked @endif
                                                            name="dorsum_hump_reduction_cartilaginous"
                                                            type="checkbox" value="1"
                                                            id="dorsum_hump_reduction_cartilaginous_up"><label
                                                                for="dorsum_hump_reduction_cartilaginous_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('dorsum_hump_reduction_cartilaginous')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum
                                                            (Augmentation)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="dorsum_augmentation"
                                                                @if($item->during_op->dorsum_augmentation) checked
                                                            @endif type="checkbox" value="1"
                                                            id="dorsum_augmentation_up"><label
                                                                for="dorsum_augmentation_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('dorsum_augmentation')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Caudal
                                                            Resection)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="dorsum_caudal_resection"
                                                                type="checkbox"
                                                                @if($item->during_op->dorsum_caudal_resection) checked
                                                            @endif
                                                            value="1"
                                                            id="dorsum_caudal_resection_up"><label
                                                                for="dorsum_caudal_resection_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('dorsum_caudal_resection')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Excision
                                                            Except Lat. Strut)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->septum_excision_except) checked
                                                            @endif
                                                            name="septum_excision_except" type="checkbox"
                                                            value="1"
                                                            id="septum_excision_except_up"><label
                                                                for="septum_excision_except_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('septum_excision_except')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Total
                                                            Excision & Reconstruction)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->septum_total_excision_reconstruction)
                                                            checked @endif
                                                            name="septum_total_excision_reconstruction"
                                                            type="checkbox" value="1"
                                                            id="septum_total_excision_reconstruction_up"><label
                                                                for="septum_total_excision_reconstruction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('septum_total_excision_reconstruction')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum
                                                            (Reconstruction)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->septum_reconstruction) checked
                                                            @endif
                                                            name="septum_reconstruction" type="checkbox"
                                                            value="1"
                                                            id="septum_reconstruction_up"><label
                                                                for="septum_reconstruction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('septum_reconstruction')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Fixation
                                                            to
                                                            the spine)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->septum_fixation_spine) checked
                                                            @endif
                                                            name="septum_fixation_spine" type="checkbox"
                                                            value="1"
                                                            id="septum_fixation_spine_up"><label
                                                                for="septum_fixation_spine_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('septum_fixation_spine')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Fixation
                                                            to
                                                            the Nasal Bones)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                @if($item->during_op->septum_fixation_nasal_bones)
                                                            checked
                                                            @endif
                                                            name="septum_fixation_nasal_bones"
                                                            type="checkbox" value="1"
                                                            id="septum_fixation_nasal_bones_up"><label
                                                                for="septum_fixation_nasal_bones_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('septum_fixation_nasal_bones')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum
                                                            (Scoring)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="septum_scoring"
                                                                @if($item->during_op->septum_scoring) checked @endif
                                                            type="checkbox" value="1"
                                                            id="septum_scoring_up"><label for="septum_scoring_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('septum_scoring')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies (Med.
                                                            Oblique)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_med_oblique"
                                                                type="checkbox"
                                                                @if($item->during_op->osteotomies_med_oblique) checked
                                                            @endif
                                                            value="1"
                                                            id="osteotomies_med_oblique_up"><label
                                                                for="osteotomies_med_oblique_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('osteotomies_med_oblique')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies
                                                            (Lateral)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_lateral"
                                                                @if($item->during_op->osteotomies_lateral) checked
                                                            @endif
                                                            type="checkbox" value="1"
                                                            id="osteotomies_lateral_up"><label
                                                                for="osteotomies_lateral_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('osteotomies_lateral')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies
                                                            (Multiple)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_multiple"
                                                                type="checkbox"
                                                                @if($item->during_op->osteotomies_multiple) checked
                                                            @endif
                                                            value="1"
                                                            id="osteotomies_multiple_up"><label
                                                                for="osteotomies_multiple_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('osteotomies_multiple')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies (Bone
                                                            carving)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_bone_carving"
                                                                @if($item->during_op->osteotomies_bone_carving) checked
                                                            @endif
                                                            type="checkbox" value="1"
                                                            id="osteotomies_bone_carving_up"><label
                                                                for="osteotomies_bone_carving_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('osteotomies_bone_carving')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats
                                                            (On-lay
                                                            Grafts)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="upper_lats_on_lay_grafts"
                                                                @if($item->during_op->upper_lats_on_lay_grafts) checked
                                                            @endif
                                                            type="checkbox" value="1"
                                                            id="upper_lats_on_lay_grafts_up"><label
                                                                for="upper_lats_on_lay_grafts_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('upper_lats_on_lay_grafts')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats (
                                                            Total
                                                            Reconstruction )</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="upper_lats_total_reconstruction" type="checkbox"
                                                                value="1"
                                                                @if($item->during_op->upper_lats_total_reconstruction)
                                                            checked @endif
                                                            id="upper_lats_total_reconstruction_up"><label
                                                                for="upper_lats_total_reconstruction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('upper_lats_total_reconstruction')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats
                                                            (Spreader Grafts)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="upper_lats_spreader_grafts"
                                                                @if ($item->during_op->upper_lats_spreader_grafts)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="upper_lats_spreader_grafts_up"><label
                                                                for="upper_lats_spreader_grafts_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('upper_lats_spreader_grafts')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats
                                                            (Spreader Flaps)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="upper_lats_spreader_flaps"
                                                                @if($item->during_op->upper_lats_spreader_flaps) checked
                                                            @endif
                                                            type="checkbox" value="1"
                                                            id="upper_lats_spreader_flaps_up"><label
                                                                for="upper_lats_spreader_flaps_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('upper_lats_spreader_flaps')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip
                                                            Plasty
                                                            (Hemidomal Suture)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_hemidomal_suture"
                                                                @if ($item->during_op->tip_plasty_hemidomal_suture)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_hemidomal_suture_up"><label
                                                                for="tip_plasty_hemidomal_suture_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tip_plasty_hemidomal_suture')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip
                                                            Plasty (Tip
                                                            Defining Suture)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="tip_plasty_tip_defining_suture"
                                                                @if($item->during_op->tip_plasty_tip_defining_suture)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_tip_defining_suture_up"><label
                                                                for="tip_plasty_tip_defining_suture_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tip_plasty_tip_defining_suture')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip
                                                            Plasty (Tip
                                                            Equalizing Suture)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="tip_plasty_tip_equalizing_suture"
                                                                @if($item->during_op->tip_plasty_tip_equalizing_suture)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_tip_equalizing_suture_up"><label
                                                                for="tip_plasty_tip_equalizing_suture_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tip_plasty_tip_equalizing_suture')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip Plasty
                                                            (Other
                                                            Sutures)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_other_sutures"
                                                                @if($item->during_op->tip_plasty_other_sutures) checked
                                                            @endif
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_other_sutures_up"><label
                                                                for="tip_plasty_other_sutures_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tip_plasty_other_sutures')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cap
                                                            Graft
                                                            (Non-Crushed Cartilage)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="cap_graft_non_crushed_cartilage"
                                                                @if($item->during_op->cap_graft_non_crushed_cartilage)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="cap_graft_non_crushed_cartilage_up"><label
                                                                for="cap_graft_non_crushed_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('cap_graft_non_crushed_cartilage')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cap Graft
                                                            (Crushed
                                                            Cartilage)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="cap_graft_crushed_cartilage"
                                                                @if ($item->during_op->cap_graft_crushed_cartilage)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="cap_graft_crushed_cartilage_up"><label
                                                                for="cap_graft_crushed_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('cap_graft_crushed_cartilage')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cap
                                                            Graft (Soft
                                                            Tissue Cartilage)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="cap_graft_soft_tissue_cartilage"
                                                                @if($item->during_op->cap_graft_soft_tissue_cartilage)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="cap_graft_soft_tissue_cartilage_up"><label
                                                                for="cap_graft_soft_tissue_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('cap_graft_soft_tissue_cartilage')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="tip_plasty_shield_graft">Tip-Plasty
                                                            (Shield
                                                            Graft)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_shield_graft"
                                                                type="checkbox"
                                                                @if($item->during_op->tip_plasty_shield_graft) checked
                                                            @endif
                                                            value="1"
                                                            id="tip_plasty_shield_graft_up"><label
                                                                for="tip_plasty_shield_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tip_plasty_shield_graft')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip-Plasty
                                                            (Columellar Strut)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_columellar_strut"
                                                                @if ($item->during_op->tip_plasty_columellar_strut)
                                                            checked @endif
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_columellar_strut_up"><label
                                                                for="tip_plasty_columellar_strut_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tip_plasty_columellar_strut')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tools (Rose
                                                            head
                                                            Drill)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_rose_head_drill"
                                                                type="checkbox"
                                                                @if($item->during_op->tools_rose_head_drill) checked
                                                            @endif
                                                            value="1"
                                                            id="tools_rose_head_drill_up"><label
                                                                for="tools_rose_head_drill_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tools_rose_head_drill')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tools (Burr
                                                            head
                                                            Drill)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_burr_head_drill"
                                                                type="checkbox"
                                                                @if($item->during_op->tools_burr_head_drill) checked
                                                            @endif
                                                            value="1"
                                                            id="tools_burr_head_drill_up"><label
                                                                for="tools_burr_head_drill_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tools_burr_head_drill')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Tools (Piezotome
                                                            )</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_piezotome"
                                                                @if($item->during_op->tools_piezotome) checked @endif
                                                            type="checkbox" value="1"
                                                            id="tools_piezotome_up"><label for="tools_piezotome_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tools_piezotome')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Tools (Hammer &
                                                            Chisel)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_hammer_chisel"
                                                                @if($item->during_op->tools_hammer_chisel) checked
                                                            @endif
                                                            type="checkbox" value="1"
                                                            id="tools_hammer_chisel_up"><label
                                                                for="tools_hammer_chisel_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tools_hammer_chisel')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsal
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="dorsal_graft"
                                                                @if($item->during_op->dorsal_graft) checked @endif
                                                            type="checkbox" value="1"
                                                            id="dorsal_graft_up"><label for="dorsal_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('dorsal_graft')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Conceal Cartilage
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="conceal_cartilage_graft"
                                                                type="checkbox"
                                                                @if($item->during_op->conceal_cartilage_graft) checked
                                                            @endif
                                                            value="1"
                                                            id="conceal_cartilage_graft_up"><label
                                                                for="conceal_cartilage_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('conceal_cartilage_graft')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Costal Cartilage
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="costal_cartilage_graft"
                                                                type="checkbox"
                                                                @if($item->during_op->costal_cartilage_graft) checked
                                                            @endif
                                                            value="1"
                                                            id="costal_cartilage_graft_up"><label
                                                                for="costal_cartilage_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('costal_cartilage_graft')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Temporal Fascial
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="temporal_fascial_graft"
                                                                type="checkbox"
                                                                @if($item->during_op->temporal_fascial_graft) checked
                                                            @endif
                                                            value="1"
                                                            id="temporal_fascial_graft_up"><label
                                                                for="temporal_fascial_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('temporal_fascial_graft')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Op. type <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="op_type" type="text"
                                                        class="form-control @error('op_type') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->other_steps }}">

                                                    <span id="op_type_error" class="error-msg-form"></span>

                                                    @error('op_type')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tools
                                                            (Raspier)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_raspier"
                                                                @if($item->during_op->tools_raspier) checked @endif
                                                            type="checkbox" value="1"
                                                            id="tools_raspier_up"><label for="tools_raspier_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('tools_raspier')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Nostril
                                                            Reduction</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="nostril_reduction"
                                                                @if($item->during_op->nostril_reduction) checked @endif
                                                            type="checkbox" value="1"
                                                            id="nostril_reduction_up"><label for="nostril_reduction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('nostril_reduction')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other steps <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="other_steps" type="text"
                                                        class="form-control @error('other_steps') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->other_steps }}">

                                                    <span id="other_steps_error" class="error-msg-form"></span>

                                                    @error('other_steps')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other Operations <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="other_operations" type="text"
                                                        class="form-control @error('other_operations') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->other_operations }}">

                                                    <span id="other_operations_error" class="error-msg-form"></span>

                                                    @error('other_operations')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cephalic
                                                            Resection of
                                                            Lat. Crus
                                                            Cartilage</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="cephalic_resection_lat_crus_cartilage"
                                                                type="checkbox" value="1"
                                                                @if($item->during_op->cephalic_resection_lat_crus_cartilage)
                                                            checked @endif
                                                            id="cephalic_resection_lat_crus_cartilage_up"><label
                                                                for="cephalic_resection_lat_crus_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    @error('cephalic_resection_lat_crus_cartilage')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Op. Duration <small>
                                                            ({{ __('basic.op_duration') }})</small></label>

                                                    <input name="op_duration" type="text"
                                                        class="form-control @error('op_duration') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->op_duration }}">

                                                    <span id="op_duration_error" class="error-msg-form"></span>

                                                    @error('op_duration')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Skin Type <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="skin_type" type="text"
                                                        class="form-control @error('skin_type') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->skin_type }}">

                                                    <span id="skin_type_error" class="error-msg-form"></span>

                                                    @error('skin_type')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other Facial Problems <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="other_facial_problems" type="text"
                                                        class="form-control @error('other_facial_problems') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->other_facial_problems }}">

                                                    <span id="other_facial_problems_error"
                                                        class="error-msg-form"></span>

                                                    @error('other_facial_problems')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Length <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="length" type="text"
                                                        class="form-control @error('length') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->length }}">

                                                    <span id="length_error" class="error-msg-form"></span>

                                                    @error('length')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Dorsal Width <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="dorsal_width" type="text"
                                                        class="form-control @error('dorsal_width') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->dorsal_width }}">

                                                    <span id="dorsal_width_error" class="error-msg-form"></span>

                                                    @error('dorsal_width')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Rotation <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="rotation" type="text"
                                                        class="form-control @error('rotation') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->rotation }}">

                                                    <span id="rotation_error" class="error-msg-form"></span>

                                                    @error('rotation')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Tip Projection <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="tip_projection" type="text"
                                                        class="form-control @error('tip_projection') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->tip_projection }}">

                                                    <span id="tip_projection_error" class="error-msg-form"></span>

                                                    @error('tip_projection')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Alar Base <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <input name="alar_base" type="text"
                                                        class="form-control @error('alar_base') is-invalid @enderror"
                                                        placeholder="Write here.."
                                                        value="{{ $item->during_op->alar_base }}">

                                                    <span id="alar_base_error" class="error-msg-form"></span>

                                                    @error('alar_base')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other Note <small>
                                                            ({{ __('basic.optional') }})</small></label>

                                                    <textarea name="other_note" class="form-control "
                                                        placeholder="Write here your note .." rows="4"
                                                        spellcheck="false">{{ $item->during_op->other_note }}</textarea>

                                                    <span id="other_note_error" class="error-msg-form"></span>

                                                    @error('other_note')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <input type="hidden" name="op_during_id"
                                                    value="{{ $item->during_op->id }}">

                                                <div class="text-center "><input
                                                        class="main-color-bg btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-blue-200"
                                                        type="submit" value="Update">
                                                </div>
                                            </div>
                                        </form>
                                        @else
                                        <div class="d-flex justify-content-between add_op_during_modal"
                                            data-id="{{ $item->id }}">
                                            <p class="text-gray-300">Here is all info during the operation</p>
                                            <div class="clickable-item-pointer">
                                                <p><i class="fas fa-plus"></i> Add New</p>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="after_op_accor">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseAfterOp" aria-expanded="true"
                                        aria-controls="collapseAfterOp">
                                        <i class="fas fa-comment-alt me-1"></i> {{ __('patientappo.after op') }}
                                    </button>
                                </h2>
                                <div id="collapseAfterOp" class="accordion-collapse collapse"
                                    aria-labelledby="after_op_accor" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">

                                        <form class="mb-0" action="{{ route('sett.operation_patient_past_note') }}"
                                            method="POST">

                                            {{ method_field('PUT') }}
                                            {{ csrf_field() }}

                                            <div class="col-12 mb-3">
                                                <label class="form-label">Past Op Note<small>
                                                        ({{ __('basic.optional') }})</small></label>

                                                <textarea name="note_after_op" class="form-control "
                                                    placeholder="Write here your note after the operation .." rows="4"
                                                    spellcheck="false">{{ $item->note_after_op }}</textarea>

                                                <span id="note_after_op_error" class="error-msg-form"></span>

                                                @error('note_after_op')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <input type="hidden" name="op_id" value="{{ $item->id }}">

                                            <div class="text-center "><input
                                                    class="main-color-bg btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-blue-200"
                                                    type="submit" value="Update">
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="gallery_op_accor">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseGallery" aria-expanded="true"
                                        aria-controls="collapseGallery">
                                        <i class="fas fa-images me-1"></i> {{ __('basic.gallery') }}
                                    </button>
                                </h2>
                                <div id="collapseGallery" class="accordion-collapse collapse"
                                    aria-labelledby="gallery_op_accor" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="d-flex justify-content-between add_op_gallery_modal"
                                            data-id="{{ $item->id }}">
                                            <p class="text-gray-300">Here is the
                                                op gallery <a class="main-color"
                                                    href="{{ route('sett.operation_gallery', $item->id) }}">CLICK
                                                    HERE FOR LIVE IMAGES</a></p>
                                            <div class="clickable-item-pointer">
                                                <p><i class="fas fa-plus"></i> Add New</p>
                                            </div>
                                        </div>

                                        <p class="text-gray-500 mb-2">Before Op Gallery</p>

                                        @foreach ($item->gallery as $key => $g_item)
                                        @if ($g_item->type == 1)
                                        <div class="d-flex ps-2 justify-content-between align-items-center mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-image fs-3 me-2"></i>
                                                <a href="{{ URL::asset('img/opgallery/' . $g_item->img) }}"
                                                    target="_blank" class="fs-6 text-gray-500" title="download">
                                                    Pre Image
                                                    {{ $key }}
                                                </a>
                                            </div>
                                            <div>
                                                <a data-img_id="{{ $g_item->id }}"
                                                    class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 op_img_delete_click"
                                                    title="delete"><i class="fas fa-trash"></i>
                                                    {{ __('basic.delete') }}
                                                </a>
                                            </div>
                                        </div>
                                        @endif
                                        @endforeach

                                        <hr>

                                        <p class="text-gray-500 mb-2">During Op Gallery</p>

                                        @foreach ($item->gallery as $key => $g_item)
                                        @if ($g_item->type == 2)
                                        <div class="d-flex ps-2 justify-content-between align-items-center mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-image fs-3 me-2"></i>
                                                <a href="{{ URL::asset('img/opgallery/' . $g_item->img) }}"
                                                    target="_blank" class="fs-6 text-gray-500" title="download">
                                                    Pre Image
                                                    {{ $key }}
                                                </a>
                                            </div>
                                            <div>
                                                <a data-img_id="{{ $g_item->id }}"
                                                    class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 op_img_delete_click"
                                                    title="delete"><i class="fas fa-trash"></i>
                                                    {{ __('basic.delete') }}
                                                </a>
                                            </div>
                                        </div>
                                        @endif
                                        @endforeach

                                        <hr>

                                        <p class="text-gray-500 mb-2">After Op Gallery</p>

                                        @foreach ($item->gallery as $key => $g_item)
                                        @if ($g_item->type == 3)
                                        <div class="d-flex ps-2 justify-content-between align-items-center mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-image fs-3 me-2"></i>
                                                <a href="{{ URL::asset('img/opgallery/' . $g_item->img) }}"
                                                    target="_blank" class="fs-6 text-gray-500" title="download">
                                                    Pre Image
                                                    {{ $key }}
                                                </a>
                                            </div>
                                            <div>
                                                <a data-img_id="{{ $g_item->id }}"
                                                    class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 op_img_delete_click"
                                                    title="delete"><i class="fas fa-trash"></i>
                                                    {{ __('basic.delete') }}
                                                </a>
                                            </div>
                                        </div>
                                        @endif
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                    </div>
                    @endforeach

                </div>

                <div class="modal-footer">

                </div>

            </div>
        </div>

    </div>

    <!-- Modal operation insert data -->
    <div class="modal fade" id="add_operation" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="{{ route('sett.app_operation_patient_add') }}" method="post" enctype="multipart/form-data"
                style="display: contents">
                {{ method_field('POST') }}
                {{ csrf_field() }}

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                            {{ __('patientappo.new operation') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('patientappo.operation catagory') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-operation-insert select2-hidden-accessible @error('oper_cat_serv_id') is-invalid @enderror"
                                    id="oper_cat_serv_id" name="oper_cat_serv_id" required>
                                    @foreach ($service_cat_oper as $item)
                                    <option value="{{ $item->id }}" data-price="{{ $item->price }}">
                                        {{ $item->name . ' - ' . $item->price . 'EGP' }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="oper_cat_serv_id_error" class="error-msg-form"></span>

                                @error('oper_cat_serv_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('patientappo.operation place') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-operation-insert select2-hidden-accessible @error('oper_place_id') is-invalid @enderror"
                                    id="oper_place_id" name="oper_place_id" required>
                                    @foreach ($operation_place as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->name }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="oper_place_id_error" class="error-msg-form"></span>

                                @error('oper_place_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.date') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="operation_start" value="{{ date('Y-m-d') }}" type="text"
                                        class="form-control hasdatetimepicker @error('operation_start') is-invalid @enderror"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="operation_start_error" class="error-msg-form"></span>

                                @error('operation_start')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.note') }}
                                    <small>({{ __('basic.optional') }})</small></label>

                                <textarea name="note_operation"
                                    class="form-control @error('note_operation') is-invalid @enderror"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="note_operation_error" class="error-msg-form"></span>

                                @error('note_operation')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.appointment') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-oper-insert-nosearch select2-hidden-accessible @error('last_appointment_id') is-invalid @enderror"
                                    id="last_appointment_id_operation" name="last_appointment_id" required>
                                    @foreach ($patient->appointments as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->start_at }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="last_appointment_id_error" class="error-msg-form"></span>

                                @error('last_appointment_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <hr class="my-2">

                            <div class="col-12 mb-2">
                                <label class="form-label"> {{ __('basic.price') }}
                                    <small>({{ __('basic.required') }})</small></label>

                                <input name="price_invoice_operation" type="number"
                                    class="form-control @error('price_invoice_operation') is-invalid @enderror"
                                    placeholder="Write here the price?" required>

                                <span id="price_invoice_update_error" class="error-msg-form"></span>

                                @error('price_invoice_operation')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.invoice note') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <textarea name="invoice_note_operation" class="form-control"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="invoice_note_operation_error" class="error-msg-form"></span>

                                @error('invoice_note_operation')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                        </div>

                        <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal operation delete -->
    <div class="modal fade" id="operation_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.operation.destroy', 'test') }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre you sure you want to delete this Operation?</p><br>
                            <input type="hidden" name="opertion_id_delete" value="">
                            <input type="hidden" name="operation_invoice_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!-- Modal operation edit -->
    <div class="modal fade" id="edit_operation" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form class="mb-0" action="{{ route('sett.app_operation_patient_edit') }}" style="display: contents"
                enctype="multipart/form-data" method="POST"> @csrf @method('PUT')

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                            {{ __('patientappo.edit operation') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('patientappo.operation catagory') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-operation-insert-nosearch select2-hidden-accessible @error('oper_cat_serv_id') is-invalid @enderror"
                                    id="oper_status_up" name="oper_status_up" required>
                                    <option value="0">Not scheduled</option>
                                    <option value="1">Scheduled</option>
                                    <option value="2">accepted</option>
                                    <option value="3">Done</option>
                                    <option value="4">Not respond</option>
                                    <option value="5">postponed</option>
                                    <option value="6">Canceled</option>
                                </select>

                                <span id="oper_status_up_error" class="error-msg-form"></span>

                                @error('oper_status_up')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.note') }}
                                    <small>({{ __('basic.optional') }})</small></label>

                                <textarea name="note_operation_up"
                                    class="form-control @error('note_operation') is-invalid @enderror"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="note_operation_error" class="error-msg-form"></span>

                                @error('note_operation')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"> {{ __('patientappo.improvment rate') }}
                                    <small>({{ __('basic.optional') }})</small></label>

                                <input name="operation_improvment_up" type="number"
                                    class="form-control @error('operation_improvment_up') is-invalid @enderror"
                                    placeholder="Write here the improvment rate from 0-5?">

                                <div class="form-text text-gray-200">The improvment rate from 0 to 5
                                </div>

                                <span id="operation_improvment_up_error" class="error-msg-form"></span>

                                @error('operation_improvment_up')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                        </div>

                        <input name="operation_id_update" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Update</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-------------- Gallery -------------->
    <!-- Modal operation insert data -->
    <div class="modal fade" id="add_gallery" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="{{ route('sett.operation_patient_add_gallery') }}" method="post" enctype="multipart/form-data"
                style="display: contents">
                {{ method_field('POST') }}
                {{ csrf_field() }}

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                            {{ __('patientappo.new op images') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.type') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-operation-img-insert select2-hidden-accessible @error('op_ga_type') is-invalid @enderror"
                                    id="op_ga_type" name="op_ga_type" required>
                                    <option value="1">
                                        Pre
                                    </option>
                                    <option value="2">
                                        During
                                    </option>
                                    <option value="3">
                                        After
                                    </option>
                                </select>

                                <span id="op_ga_type_error" class="error-msg-form"></span>

                                @error('op_ga_type')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2 ">
                                <label class="form-label">Images
                                    <small>({{ __('basic.requried') }})</small></label>
                                <input class="form-control file_dropzone_cuts" name='op_imgs[]' accept="image/*"
                                    type="file" id="formFile" multiple required>

                                <div class="form-text text-gray-200">Insert here all picture and every image must
                                    be less than 15MB.
                                </div>

                                <span id="op_imgs_error" class="error-msg-form"></span>

                                @error('op_imgs')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                        </div>

                        <input name="patient_id" value="{{ $patient->id }}" type="hidden">
                        <input name="gallery-op-id" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal operation delete -->
    <div class="modal fade" id="op_gallery_img_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.operation_patient_delete_gallery') }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre you sure you want to delete this Op Img?</p><br>
                            <input type="hidden" name="opertion_id_op_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!-- Modal operation insert during -->
    <div class="modal fade" id="add_during_op" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="{{ route('sett.operation_patient_during_op') }}" method="post" style="display: contents">
                {{ method_field('POST') }}
                {{ csrf_field() }}

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                            {{ __('patientappo.new op images') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2 text-gray-700">

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum (Hump
                                        Reduction Bony)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_hump_reduction_bony" type="checkbox"
                                            value="1" id="dorsum_hump_reduction_bony"><label
                                            for="dorsum_hump_reduction_bony" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum
                                        (Hump
                                        Reduction Septal)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_hump_reduction_septal" type="checkbox"
                                            value="1" id="dorsum_hump_reduction_septal"><label
                                            for="dorsum_hump_reduction_septal" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum (Hump
                                        Reduction Cartilaginous)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_hump_reduction_cartilaginous"
                                            type="checkbox" value="1" id="dorsum_hump_reduction_cartilaginous"><label
                                            for="dorsum_hump_reduction_cartilaginous"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum
                                        (Augmentation)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_augmentation" type="checkbox" value="1"
                                            id="dorsum_augmentation"><label for="dorsum_augmentation"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Caudal
                                        Resection)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_caudal_resection" type="checkbox" value="1"
                                            id="dorsum_caudal_resection"><label for="dorsum_caudal_resection"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Excision
                                        Except Lat. Strut)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_excision_except" type="checkbox" value="1"
                                            id="septum_excision_except"><label for="septum_excision_except"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Total
                                        Excision & Reconstruction)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_total_excision_reconstruction"
                                            type="checkbox" value="1" id="septum_total_excision_reconstruction"><label
                                            for="septum_total_excision_reconstruction"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum
                                        (Reconstruction)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_reconstruction" type="checkbox" value="1"
                                            id="septum_reconstruction"><label for="septum_reconstruction"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Fixation to
                                        the spine)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_fixation_spine" type="checkbox" value="1"
                                            id="septum_fixation_spine"><label for="septum_fixation_spine"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Fixation to
                                        the Nasal Bones)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_fixation_nasal_bones" type="checkbox"
                                            value="1" id="septum_fixation_nasal_bones"><label
                                            for="septum_fixation_nasal_bones" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum
                                        (Scoring)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_scoring" type="checkbox" value="1"
                                            id="septum_scoring"><label for="septum_scoring"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies (Med.
                                        Oblique)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_med_oblique" type="checkbox" value="1"
                                            id="osteotomies_med_oblique"><label for="osteotomies_med_oblique"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies
                                        (Lateral)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_lateral" type="checkbox" value="1"
                                            id="osteotomies_lateral"><label for="osteotomies_lateral"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies
                                        (Multiple)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_multiple" type="checkbox" value="1"
                                            id="osteotomies_multiple"><label for="osteotomies_multiple"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies (Bone
                                        carving)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_bone_carving" type="checkbox"
                                            value="1" id="osteotomies_bone_carving"><label
                                            for="osteotomies_bone_carving" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats (On-lay
                                        Grafts)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_on_lay_grafts" type="checkbox"
                                            value="1" id="upper_lats_on_lay_grafts"><label
                                            for="upper_lats_on_lay_grafts" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats ( Total
                                        Reconstruction )</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_total_reconstruction" type="checkbox"
                                            value="1" id="upper_lats_total_reconstruction"><label
                                            for="upper_lats_total_reconstruction" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats
                                        (Spreader Grafts)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_spreader_grafts" type="checkbox"
                                            value="1" id="upper_lats_spreader_grafts"><label
                                            for="upper_lats_spreader_grafts" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats
                                        (Spreader Flaps)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_spreader_flaps" type="checkbox"
                                            value="1" id="upper_lats_spreader_flaps"><label
                                            for="upper_lats_spreader_flaps" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip
                                        Plasty
                                        (Hemidomal Suture)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_hemidomal_suture" type="checkbox"
                                            value="1" id="tip_plasty_hemidomal_suture"><label
                                            for="tip_plasty_hemidomal_suture" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip
                                        Plasty (Tip
                                        Defining Suture)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_tip_defining_suture" type="checkbox"
                                            value="1" id="tip_plasty_tip_defining_suture"><label
                                            for="tip_plasty_tip_defining_suture" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip
                                        Plasty (Tip
                                        Equalizing Suture)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_tip_equalizing_suture" type="checkbox"
                                            value="1" id="tip_plasty_tip_equalizing_suture"><label
                                            for="tip_plasty_tip_equalizing_suture"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip Plasty
                                        (Other
                                        Sutures)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_other_sutures" type="checkbox"
                                            value="1" id="tip_plasty_other_sutures"><label
                                            for="tip_plasty_other_sutures" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cap
                                        Graft
                                        (Non-Crushed Cartilage)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cap_graft_non_crushed_cartilage" type="checkbox"
                                            value="1" id="cap_graft_non_crushed_cartilage"><label
                                            for="cap_graft_non_crushed_cartilage" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cap Graft
                                        (Crushed
                                        Cartilage)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cap_graft_crushed_cartilage" type="checkbox"
                                            value="1" id="cap_graft_crushed_cartilage"><label
                                            for="cap_graft_crushed_cartilage" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cap
                                        Graft (Soft
                                        Tissue Cartilage)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cap_graft_soft_tissue_cartilage" type="checkbox"
                                            value="1" id="cap_graft_soft_tissue_cartilage"><label
                                            for="cap_graft_soft_tissue_cartilage" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="tip_plasty_shield_graft">Tip-Plasty
                                        (Shield
                                        Graft)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_shield_graft" type="checkbox" value="1"
                                            id="tip_plasty_shield_graft"><label for="tip_plasty_shield_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip-Plasty
                                        (Columellar Strut)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_columellar_strut" type="checkbox"
                                            value="1" id="tip_plasty_columellar_strut"><label
                                            for="tip_plasty_columellar_strut" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tools (Rose
                                        head
                                        Drill)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_rose_head_drill" type="checkbox" value="1"
                                            id="tools_rose_head_drill"><label for="tools_rose_head_drill"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tools (Burr
                                        head
                                        Drill)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_burr_head_drill" type="checkbox" value="1"
                                            id="tools_burr_head_drill"><label for="tools_burr_head_drill"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Tools (Piezotome
                                        )</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_piezotome" type="checkbox" value="1"
                                            id="tools_piezotome"><label for="tools_piezotome"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Tools (Hammer &
                                        Chisel)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_hammer_chisel" type="checkbox" value="1"
                                            id="tools_hammer_chisel"><label for="tools_hammer_chisel"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsal Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsal_graft" type="checkbox" value="1"
                                            id="dorsal_graft"><label for="dorsal_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Conceal Cartilage Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="conceal_cartilage_graft" type="checkbox" value="1"
                                            id="conceal_cartilage_graft"><label for="conceal_cartilage_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Costal Cartilage
                                        Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="costal_cartilage_graft" type="checkbox" value="1"
                                            id="costal_cartilage_graft"><label for="costal_cartilage_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('costal_cartilage_graft')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Temporal Fascial
                                        Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="temporal_fascial_graft" type="checkbox" value="1"
                                            id="temporal_fascial_graft"><label for="temporal_fascial_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('temporal_fascial_graft')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Op. type <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="op_type" type="text"
                                    class="form-control @error('op_type') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="op_type_error" class="error-msg-form"></span>

                                @error('op_type')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tools (Raspier)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_raspier" type="checkbox" value="1"
                                            id="tools_raspier"><label for="tools_raspier"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('tools_raspier')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Nostril
                                        Reduction</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="nostril_reduction" type="checkbox" value="1"
                                            id="nostril_reduction"><label for="nostril_reduction"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('nostril_reduction')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other steps <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="other_steps" type="text"
                                    class="form-control @error('other_steps') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="other_steps_error" class="error-msg-form"></span>

                                @error('other_steps')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other Operations <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="other_operations" type="text"
                                    class="form-control @error('other_operations') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="other_operations_error" class="error-msg-form"></span>

                                @error('other_operations')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cephalic Resection of Lat. Crus
                                        Cartilage</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cephalic_resection_lat_crus_cartilage"
                                            type="checkbox" value="1" id="cephalic_resection_lat_crus_cartilage"><label
                                            for="cephalic_resection_lat_crus_cartilage"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                @error('cephalic_resection_lat_crus_cartilage')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Op. Duration <small>
                                        ({{ __('basic.op_duration') }})</small></label>

                                <input name="op_duration" type="text"
                                    class="form-control @error('op_duration') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="op_duration_error" class="error-msg-form"></span>

                                @error('op_duration')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Skin Type <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="skin_type" type="text"
                                    class="form-control @error('skin_type') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="skin_type_error" class="error-msg-form"></span>

                                @error('skin_type')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other Facial Problems <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="other_facial_problems" type="text"
                                    class="form-control @error('other_facial_problems') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="other_facial_problems_error" class="error-msg-form"></span>

                                @error('other_facial_problems')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Length <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="length" type="text"
                                    class="form-control @error('length') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="length_error" class="error-msg-form"></span>

                                @error('length')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Dorsal Width <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="dorsal_width" type="text"
                                    class="form-control @error('dorsal_width') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="dorsal_width_error" class="error-msg-form"></span>

                                @error('dorsal_width')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Rotation <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="rotation" type="text"
                                    class="form-control @error('rotation') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="rotation_error" class="error-msg-form"></span>

                                @error('rotation')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Tip Projection <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="tip_projection" type="text"
                                    class="form-control @error('tip_projection') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="tip_projection_error" class="error-msg-form"></span>

                                @error('tip_projection')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Alar Base <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <input name="alar_base" type="text"
                                    class="form-control @error('alar_base') is-invalid @enderror"
                                    placeholder="Write here..">

                                <span id="alar_base_error" class="error-msg-form"></span>

                                @error('alar_base')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other Note <small>
                                        ({{ __('basic.optional') }})</small></label>

                                <textarea name="other_note" class="form-control " placeholder="Write here your note .."
                                    rows="4" spellcheck="false"></textarea>

                                <span id="other_note_error" class="error-msg-form"></span>

                                @error('other_note')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>
                        </div>

                        <input name="patient_id" value="{{ $patient->id }}" type="hidden">
                        <input name="during-op-id" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>





    <!-- Modal new attachment insert data -->
    <div class="modal fade" id="add_attachment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="{{ route('sett.pat_add_new_attachment') }}" method="post" enctype="multipart/form-data"
                style="display: contents">
                {{ method_field('POST') }}
                {{ csrf_field() }}

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-image me-1"></i>
                            {{ __('basic.new attachment') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('basic.name') }} <small>
                                    ({{ __('basic.optional') }})</small></label>
                            <input name="attachments_name" type="text"
                                class="form-control @error('attachments_name') is-invalid @enderror"
                                placeholder="Write here the attachment name .." maxlength="35">

                            <span id="attachments_name" class="error-msg-form"></span>

                            @error('attachments_name')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror
                        </div>

                        <div class="col-12 mb-2 ">
                            <label class="form-label">{{ __('basic.attachments') }}
                                <small>({{ __('basic.requried') }})</small></label>
                            <input class="form-control file_dropzone_cuts" name='attachments_imgs[]' accept="image/*"
                                type="file" id="formFile" multiple required>

                            <div class="form-text text-gray-200">Insert here all picture and every image must
                                be less than 2MB.
                            </div>

                            <span id="op_imgs_error" class="error-msg-form"></span>

                            @error('attachments_imgs')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror
                        </div>

                        <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>




    <!-- Modal show all lab -->
    <div class="modal fade" id="attachment_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-image me-1"></i>
                        {{ __('basic.attachments') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    @foreach ($patient->attachments as $item)
                    <div class="d-flex justify-content-between align-items-center mb-3">

                        <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                            <i class="fas fa-image me-2 fs-4 mb-0 {{ $item->name }}"></i>

                            <div class="text-truncate">
                                <p class="text-gray-300 text-xxs mb-0">
                                    {{ $item->date }}</p>
                                <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                    {{ $item->name }}
                                </p>
                            </div>
                        </div>
                        <div>
                            <a data-img_id="{{ $item->id }}"
                                class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 attachment_img_delete_click"
                                title="delete"><i class="fas fa-trash"></i>
                            </a>
                            <a href="{{ URL::asset('img/pat_attachments/' . $item->img) }}" target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l">{{
                                    __('basic.download')
                                    }}</span>
                            </a>
                        </div>

                    </div>
                    @endforeach

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                            __('basic.never mind') }}</button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button id="new_attachment_modal" type="button" class="btn btn-default btn-link main-color">{{
                            __('basic.new attachment')
                            }}</button>
                    </div>
                </div>

            </div>
        </div>

    </div>


    <!-- Modal operation delete -->
    <div class="modal fade" id="attachment_gallery_img_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.pat_delete_new_attachment') }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre you sure you want to delete this Op Img?</p><br>
                            <input type="hidden" name="attachment_id_op_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>