<!-- Appointments -->
<div class="@if (Auth::user()->hasRole('Call-center')) col @else col-lg-7 @endif page-break pe-0 pe-md-3">
    <div class="card shadow mb-4">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold">{{ __('patientappo.appointment timeline') }}</h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Appointment controller:</div>
                    <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#add_past_app">Add
                        past Appointment</a>
                    <a class="dropdown-item add_info_old_appo clickable-item-pointer">{{ __('patientappo.old appointment
                        info') }}</a>
                    <a class="dropdown-item add_info_exsit_appo clickable-item-pointer">{{ __('patientappo.exist
                        appointment info') }}</a>
                </div>
            </div>
        </div>

        <!-- Card Body -->
        <div class="card-body pb-2 overflow-scroll">

            @if (count($patient->appointments) > 0)
            <ul class="list-group patient-timeline">

                @foreach ($patient->appointments as $item)
                @if ($item->status == 0)
                @php
                $text_color = 'not_accepted-color';
                $msg = __('patientappo.not accepted');
                @endphp
                @elseif ($item->status == 1)
                @php
                $text_color = 'main-color';
                $msg = __('patientappo.accepted');
                @endphp
                @elseif ($item->status == 2)
                @php
                $text_color = 'arrived-color';
                $msg = __('patientappo.arrived');
                @endphp
                @elseif ($item->status == 3)
                @php
                $text_color = 'inprog-color';
                $msg = __('patientappo.with doctor');
                @endphp
                @elseif ($item->status == 4)
                @php
                $text_color = 'done-color';
                $msg = __('patientappo.done appointment');
                @endphp
                @elseif ($item->status == 5)
                @php
                $text_color = 'notresp-color';
                $msg = __('patientappo.not respond');
                @endphp
                @elseif ($item->status == 6)
                @php
                $text_color = 'cancel-color';
                $msg = __('patientappo.canceled');
                @endphp
                @endif

                @if ($item->invoice_item)
                @if ($item->invoice_item->invoice->status == 0)
                @php
                $msg_invoice = __('basic.not paid');
                @endphp
                @elseif ($item->invoice_item->invoice->status == 1)
                @php
                $msg_invoice = __('basic.pending');
                @endphp
                @elseif ($item->invoice_item->invoice->status == 2)
                @php
                $msg_invoice = __('basic.installment');
                @endphp
                @elseif ($item->invoice_item->invoice->status == 3)
                @php
                $msg_invoice = __('basic.paid');
                @endphp
                @elseif ($item->invoice_item->invoice->status == 4)
                @php
                $msg_invoice = __('basic.refund');
                @endphp
                @endif
                @else
                @php
                $msg_invoice = 'No fees';
                @endphp
                @endif

                {{-- blade-formatter-disable-next-line --}}
                @break($loop->index === 3)

                @if ($item->note_doctor)
                @php
                $icon_note = 'fa-user-check text-blue-400';
                @endphp
                @else
                @php
                $icon_note = 'fa-user-edit text-grey-400';
                @endphp
                @endif

                <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">

                    <i class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 {{ $text_color }}"></i>

                    <div class="col me-1">
                        <p class="text-xxs text-gray-200 mb-0">
                            {{ date('h:i a', strtotime($item->start_at)) }}</p>
                        <h6 class="text-s fw-bold {{ $text_color }} mb-0">
                            {{ date('d M Y', strtotime($item->start_at)) }}</h6>
                        <p class="text-xs {{ $text_color }} fw-bold mb-0">
                            {{ $msg . ', ' . $msg_invoice }}
                        </p>
                    </div>

                    <div class="col text-center align-self-center me-1">
                        <p class="text-xs text-gray-200 mb-0">{{ __('basic.type') }}</p>
                        <h6 class="text-s text-gray-400">{{ $item->service_item->name }}</h6>
                    </div>

                    <div class="col text-center align-self-center me-1">
                        <p class="text-xs text-gray-200 mb-0">{{ __('basic.doctor') }}</p>
                        <h6 class="text-s text-gray-400 text-truncate">
                            @if (isset($item->doctor->first_name))
                            {{ $item->doctor->first_name }}
                            @else
                            Not selected
                            @endif
                        </h6>
                    </div>

                    <div class="col text-center align-self-center">
                        <p class="text-xs text-gray-200 mb-0">{{ __('basic.handle') }}</p>
                        <a data-id="{{ $item->id }}" data-note_doctor="{{ $item->note_doctor }}"
                            class="text-s text-gray-400 clickable-item-pointer get_all_info_appointment">
                            <i class="fas fa-info-circle m-1 fs-6"></i>
                        </a>
                        <a data-id="{{ $item->id }}" data-note_doctor="{{ $item->note_doctor }}"
                            class="text-s text-gray-400 clickable-item-pointer appointment_note_click">
                            <i class="fas {{ $icon_note }} m-1 fs-6"></i>
                        </a>
                    </div>

                </li>
                @endforeach

            </ul>
            @else
            <div class="text-center">
                <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                <p class="fw-light mb-0">{{ __('basic.nothing to show') }}</p>
            </div>
            @endif
        </div>

        <!-- Card footer -->
        <div class="card-footer text-center ">
            <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                data-bs-target="#appointment_show">
                <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
            </a>
        </div>

    </div>

    <!-- Modal show all appointment -->
    <div class="modal fade" id="appointment_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                        {{ __('basic.appointments') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-appointment" width="100%"
                            cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs">{{ __('basic.name') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.branch') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.doctor') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.start') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.end') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.status') }}</th>
                                    <th class="text-xs text-center">{{ __('patientappo.pay status') }}
                                    </th>
                                    <th class="text-xs text-center">{{ __('patientappo.pay code') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.created') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.updated') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.handle') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($patient->appointments as $item)
                                @if ($item->status == 0)
                                @php
                                $text_color = 'not_accepted-color-btn';
                                $msg = __('patientappo.not accepted');
                                @endphp
                                @elseif ($item->status == 1)
                                @php
                                $text_color = 'main-color-btn';
                                $msg = __('patientappo.accepted');
                                @endphp
                                @elseif ($item->status == 2)
                                @php
                                $text_color = 'active-color-btn';
                                $msg = __('patientappo.arrived');
                                @endphp
                                @elseif ($item->status == 3)
                                @php
                                $text_color = 'prog-color-btn';
                                $msg = __('patientappo.with doctor');
                                @endphp
                                @elseif ($item->status == 4)
                                @php
                                $text_color = 'done-color-btn';
                                $msg = __('patientappo.done appointment');
                                @endphp
                                @elseif ($item->status == 5)
                                @php
                                $text_color = 'pend-color-btn';
                                $msg = __('patientappo.not respond');
                                @endphp
                                @elseif ($item->status == 6)
                                @php
                                $text_color = 'cancel-color-btn';
                                $msg = __('patientappo.canceled');
                                @endphp
                                @endif

                                @if ($item->invoice_item)
                                @if ($item->invoice_item->invoice->status == 0)
                                @php
                                $msg_invoice = __('basic.not paid');
                                $text_color_invoice = 'cancel-color-btn';
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 1)
                                @php
                                $text_color_invoice = 'pend-color-btn';
                                $msg_invoice = __('basic.pending');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 2)
                                @php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 3)
                                @php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.paid');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 4)
                                @php
                                $msg_invoice = __('basic.refund');
                                $text_color_invoice = 'cancel-color-btn';
                                @endphp
                                @endif
                                @else
                                @php
                                $msg_invoice = 'No fees';
                                $text_color_invoice = 'done-color-btn';
                                @endphp
                                @endif

                                @if ($item->note_doctor)
                                @php
                                $icon_note = 'fa-user-check text-blue-400';
                                @endphp
                                @else
                                @php
                                $icon_note = 'fa-user-edit text-grey-400';
                                @endphp
                                @endif

                                <tr>
                                    <td>{{ $item->service_item->name }}</td>
                                    <td class="text-center">{{ $item->branch->name }}</td>
                                    <td class="text-center">
                                        @isset($item->doctor->first_name)
                                        {{ $item->doctor->first_name }}
                                        @endisset
                                    </td>
                                    <td class="text-center">
                                        {{ date('Y-m-d', strtotime($item->start_at)) }} <br>
                                        {{ date('h:i a', strtotime($item->start_at)) }}</td>
                                    <td class="text-center">
                                        {{ date('Y-m-d', strtotime($item->end_at)) }} <br>
                                        {{ date('h:i a', strtotime($item->end_at)) }}</td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg }}</span>
                                    </td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{
                                            $msg_invoice }}</span>
                                    </td>
                                    <td class="text-center">
                                        @if ($item->invoice_item)
                                        {{ $item->invoice_item->invoice->code }}
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        -{{ date('Y-m-d', strtotime($item->created_at)) }} <br>
                                        @if($item->creator)
                                        -{{ $item->creator->name }}
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        -{{ date('Y-m-d', strtotime($item->updated_at)) }} <br>
                                        @if($item->last_update_person)
                                        -{{ $item->last_update_person->name }}
                                        @endif
                                    </td>
                                    <td class="text-center d-flex justify-content-center">
                                        <a data-id="{{ $item->id }}" data-note_doctor="{{ $item->note_doctor }}"
                                            class="text-s text-gray-400 clickable-item-pointer get_all_info_appointment">
                                            <i class="fas fa-info-circle m-1 fs-6"></i>
                                        </a>
                                        <a data-id="{{ $item->id }}" data-note_doctor="{{ $item->note_doctor }}"
                                            class="text-s text-gray-400 clickable-item-pointer appointment_note_click">
                                            <i class="fas {{ $icon_note }} m-1 fs-6"></i>
                                        </a>
                                        <a data-id="{{ $item->id }}"
                                            class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 appointment_delete_click"
                                            title="delete" data-effect="effect-scale"><i class="fas fa-trash"></i>
                                            {{ __('basic.delete') }}
                                        </a>
                                    </td>

                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                            __('basic.never mind') }}</button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="button" class="btn btn-default btn-link main-color">{{ __('basic.save changes')
                            }}</button>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <!-- Modal for inserting the past appointments -->
    <div class="modal fade" id="add_past_app" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                        {{ __('patientappo.last appointment') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.app_past_appointment') }}" method="post">
                    {{ method_field('POST') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">
                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.branch') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-appo-insert select2-hidden-accessible @error('branch_appo') is-invalid @enderror"
                                    id="branch_appo" name="branch_appo" required>
                                    @foreach ($branches as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->name }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="branch_appo_error" class="error-msg-form"></span>

                                @error('branch_appo')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.doctor') }}
                                    <small>({{ __('basic.required') }})</small></label>

                                <select
                                    class="myselect2-appo-insert select2-hidden-accessible @error('responsible_doc_app') is-invalid @enderror"
                                    id="responsible_doc_app" name="responsible_doc_app" required>
                                    @foreach ($doctors as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->name }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="responsible_doc_app_error" class="error-msg-form"></span>

                                @error('responsible_doc_app')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.start') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="appo_date" type="text"
                                        class="form-control datepicker_time bg-white @error('appo_date') is-invalid @enderror"
                                        placeholder="YYYY/MM/DD HM" data-enable-time="true" required>
                                </div>
                                <span id="appo_date_error" class="error-msg-form"></span>

                                @error('appo_date')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                        </div>

                        <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

    </div>

    <!-- doctor note Modal -->
    <div class="modal fade" id="appointment_note" tabindex="-1" aria-labelledby="exampleModalLabel2" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2"><i class="fas fa-quote-left me-1"></i>
                        Appointment Doctor Note</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.app_appointment_note', 'sd') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <!-- Modal content -->
                    <div class="modal-body px-4">
                        <div class="mb-3">
                            <label class="form-label">{{ __('basic.note') }}
                                <small></small></label>
                            <textarea id="appointment_note_input" name="note_appointment" class="form-control"
                                placeholder="Write here your note .." rows="4" spellcheck="false"
                                date-text="Write here your note .."></textarea>
                        </div>
                        <input type="hidden" name="note_appointment_id">
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">{{ __('basic.save
                                changes') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </div>

    <!-- inserting new examination, treatment, medicnes and etc.. from exist or old appointment -->
    <div class="modal fade" id="new_appo_patient" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                        {{ __('patientappo.last appointment') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-3 py-3 pt-1 pb-4">

                    <div class="multi-setps-form-calander col-12">

                        <form id="myform" method="POST"
                            action="{{ route('sett.pat_add_all_pt_info_appo', $patient->id) }}"
                            enctype="multipart/form-data">
                            @csrf

                            <!-- progressbar -->
                            <ul class="ps-0 progressbar_5icons progressbar" id="progressbar">
                                <li class="active">
                                    <a>
                                        <!-- in case we want to use prog selector href="#clinics" -->
                                        <div
                                            class="icon-circle checked d-flex align-items-center justify-content-center">
                                            <i class="bi bi-calendar-range"></i>
                                        </div>
                                        <span>{{ __('basic.appointment') }}</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-stethoscope"></i>
                                        </div>
                                        <span>{{ __('basic.examination') }}</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-file-medical"></i>
                                        </div>
                                        <span>{{ __('basic.treatment') }}</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-capsules"></i>
                                        </div>
                                        <span>{{ __('basic.medicines') }}</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-vial"></i>
                                        </div>
                                        <span>{{ __('patientappo.sessions') }}</span>
                                    </a>
                                </li>
                            </ul>

                            <!-- content -->

                            <div class="cont_tap px-2 px-md-3" id="clinics">

                                <div class="row">

                                    <div class="col-6 border-right-gray">

                                        <div id="patient_add_info_exist_appo" style="display: none">
                                            <h6 class="text-gray-300 mb-2">Exist appointment</h6>

                                            <div class="col-12">
                                                <label class="form-label">{{ __('basic.appointment') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="select2-no-search-appo-patient select2-hidden-accessible @error('exist_appointment_id') is-invalid @enderror"
                                                    id="exist_appointment_id_input" name="exist_appointment_id"
                                                    required>
                                                    @foreach ($patient->appointments as $item)
                                                    <option value="{{ $item->id }}">
                                                        {{ $item->start_at }}
                                                    </option>
                                                    @endforeach
                                                </select>

                                                <span id="exist_appointment_id_error" class="error-msg-form"></span>

                                                @error('exist_appointment_id')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>
                                        </div>

                                        <div id="patient_add_info_old_appo">

                                            <h6 class="text-gray-300 mb-2">Create old Appointment</h6>

                                            <div class="col-12 mb-2">
                                                <label class="form-label">{{ __('basic.branch') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="myselect2-appo-patient select2-hidden-accessible @error('branch_appo') is-invalid @enderror"
                                                    id="branch_appo_new" name="branch_appo" required>
                                                    @foreach ($branches as $item)
                                                    <option value="{{ $item->id }}">
                                                        {{ $item->name }}
                                                    </option>
                                                    @endforeach
                                                </select>

                                                <span id="branch_appo_error" class="error-msg-form"></span>

                                                @error('branch_appo')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label">{{ __('basic.doctor') }}
                                                    <small>({{ __('basic.required') }})</small></label>

                                                <select
                                                    class="myselect2-appo-patient select2-hidden-accessible @error('responsible_doc_app') is-invalid @enderror"
                                                    id="responsible_doc_app_new" name="responsible_doc_app" required>
                                                    @foreach ($doctors as $item)
                                                    <option value="{{ $item->id }}">
                                                        {{ $item->name }}
                                                    </option>
                                                    @endforeach
                                                </select>

                                                <span id="responsible_doc_app_error" class="error-msg-form"></span>

                                                @error('responsible_doc_app')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label">{{ __('basic.start') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text"><i
                                                                class="bi bi-calendar2-week-fill"></i>
                                                        </div>
                                                    </div>
                                                    <input name="appo_date" type="text"
                                                        class="form-control datepicker_time bg-white @error('appo_date') is-invalid @enderror"
                                                        placeholder="YYYY/MM/DD HM" data-enable-time="true" required>
                                                </div>
                                                <span id="appo_date_error" class="error-msg-form"></span>

                                                @error('appo_date')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-6">

                                        <div class="row">

                                            <h6 class="text-gray-300 mb-2">Basic Info</h6>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"> {{ __('patientappo.weight') }}
                                                    <small>({{ __('basic.optional') }})</small></label>

                                                <input name="weight_appo" type="number"
                                                    class="form-control @error('weight_appo') is-invalid @enderror"
                                                    placeholder="Patient weight.." value="{{ $patient->weight }}">

                                                <span id="weight_appo_error" class="error-msg-form"></span>

                                                @error('weight_appo')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"> {{ __('patientappo.heart rate') }}
                                                    <small>({{ __('basic.optional') }})</small></label>

                                                <input name="heart_rate" type="number"
                                                    class="form-control @error('heart_rate') is-invalid @enderror"
                                                    placeholder="Patient heart rate.."
                                                    value="{{ $patient->heart_rate }}">

                                                <span id="heart_rate_error" class="error-msg-form"></span>

                                                @error('heart_rate')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"> {{ __('patientappo.bl pressure') }}
                                                    <small>({{ __('basic.optional') }})</small></label>

                                                <input name="bl_pressure" type="text"
                                                    class="form-control @error('bl_pressure') is-invalid @enderror"
                                                    placeholder="Patient bl pressure.."
                                                    value="{{ $patient->bl_pressure }}">

                                                <span id="bl_pressure_error" class="error-msg-form"></span>

                                                @error('bl_pressure')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                        </div>

                                    </div>
                                </div>

                                <div class="d-flex justify-content-end mt-3 align-items-center">
                                    <input type="button" name="next"
                                        class="next-form-steps btn btn-primary action-button-next" value="Continue" />
                                </div>
                            </div>


                            <div class="cont_tap" id="time">

                                <div class="row mb-2 justify-content-center">

                                    <div class="col-12 mb-4">
                                        <div class="d-flex justify-content-center flex-wrap">

                                            <div class="mb-3 mb-md-0"
                                                style="background-image: url('{{ asset('img/dashboard/system/human_front.jpg') }}'); width:255px; height:457px; position: relative;">

                                                <canvas class="canvas" id="canvas_appo" width="255" height="457"
                                                    style=" solid;position: absolute;top:0;left:0;"></canvas>

                                                <div id="canvas-clear_appo" class="btn btn-primary"
                                                    style="position: absolute; bottom:40px; left:0px;"><i
                                                        class="fas fa-eraser"></i>
                                                </div>

                                                <div id="imgsave_appo" class="btn btn-danger"
                                                    style="position: absolute; bottom:0px; left:0px;"><i
                                                        id="icon_save_appo" class="fas fa-check"></i>
                                                </div>

                                                <div style="position: absolute; bottom:100px; left:0px;">
                                                    <div class="d-flex mb-1">
                                                        <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#000000"
                                                            style="width:10px;height:10px;background:#000000;">
                                                        </div>
                                                        <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#0cb6ed"
                                                            style="width:10px;height:10px;background:#0cb6ed;">
                                                        </div>
                                                        <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#17c34e"
                                                            style="width:10px;height:10px;background:#17c34e;">
                                                        </div>
                                                    </div>
                                                    <div class="d-flex">
                                                        <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#dc3545"
                                                            style="width:10px;height:10px;background:#dc3545;">
                                                        </div>
                                                        <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#ffd807"
                                                            style="width:10px;height:10px;background:#ffd807;">
                                                        </div>
                                                        <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#ff6d00"
                                                            style="width:10px;height:10px;background:#ff6d00;">
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>

                                            <div
                                                style="background-image: url('{{ asset('img/dashboard/system/human_back.jpg') }}'); width:255px; height:457px; position: relative;">
                                                <canvas class="canvas" id="canvas_b_appo" width="255" height="457"
                                                    style=" solid;position: absolute;top:0;left:0;"></canvas>

                                                <div id="canvas-clear_b_appo" class="btn btn-primary"
                                                    style="position: absolute; bottom:40px; left:0px;"><i
                                                        class="fas fa-eraser"></i>
                                                </div>

                                                <div id="imgsave_b_appo" class="btn btn-danger"
                                                    style="position: absolute; bottom:0px; left:0px;"><i
                                                        id="icon_save_b_appo" class="fas fa-check"></i>
                                                </div>


                                                <div style="position: absolute; bottom:100px; left:0px;">
                                                    <div class="d-flex mb-1">
                                                        <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#000000"
                                                            style="width:10px;height:10px;background:#000000;">
                                                        </div>
                                                        <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#0cb6ed"
                                                            style="width:10px;height:10px;background:#0cb6ed;">
                                                        </div>
                                                        <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#17c34e"
                                                            style="width:10px;height:10px;background:#17c34e;">
                                                        </div>
                                                    </div>
                                                    <div class="d-flex">
                                                        <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#dc3545"
                                                            style="width:10px;height:10px;background:#dc3545;">
                                                        </div>
                                                        <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#ffd807"
                                                            style="width:10px;height:10px;background:#ffd807;">
                                                        </div>
                                                        <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                            data-color="#ff6d00"
                                                            style="width:10px;height:10px;background:#ff6d00;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <input name="front" id="front_input_appo" type="hidden">
                                        <input name="back" id="back_input_appo" type="hidden">
                                    </div>

                                    <div class="col-12 col-md-8 mb-2">
                                        <label class="form-label">{{ __('basic.disease') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-appo-patient select2-hidden-accessible @error('disease_cat') is-invalid @enderror"
                                            id="disease_cat_appo" multiple="" name="disease_cat[]"
                                            style="position: relative" required>
                                            @foreach ($disease_cat as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="disease_cat_error" class="error-msg-form"></span>

                                        @error('disease_cat')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 col-md-8 mb-2">
                                        <label class="form-label">{{ __('basic.start') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="disease_start" type="text"
                                                class="form-control hasdatetimepicker @error('disease_start') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="disease_start_error" class="error-msg-form"></span>

                                        @error('disease_start')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 col-md-8 mb-2">
                                        <label class="form-label">{{ __('basic.note') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <textarea name="note_diseases" class="form-control "
                                            placeholder="Write here your note .." rows="4"
                                            spellcheck="false"></textarea>
                                        <span id="note_diseases_lab_error" class="error-msg-form"></span>
                                    </div>

                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                        <span class="next-form-steps text-gray-300 me-3 clickable-item-pointer"
                                            data-skip="true">Skip</span>
                                        <input type="button" name="next"
                                            class="next-form-steps btn btn-primary action-button-next"
                                            value="Continue" />
                                    </div>
                                </div>

                            </div>

                            <div class="cont_tap" id="treatment">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.treatment') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-appo-patient select2-hidden-accessible @error('treatment_cat') is-invalid @enderror"
                                            id="treatment_cat_appo" name="treatment_cat" required>
                                            <option selected disabled>Not Selected</option>
                                            @foreach ($treatment_cat as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="treatment_cat_error" class="error-msg-form"></span>

                                        @error('treatment_cat')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> {{ __('patientappo.sessions') }}
                                            <small>({{ __('basic.required') }})</small></label>

                                        <input name="treatment_session" type="number"
                                            class="form-control @error('treatment_session') is-invalid @enderror"
                                            placeholder="How many session?" required>

                                        <span id="treatment_session_error" class="error-msg-form"></span>

                                        @error('treatment_session')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.start') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_start" type="text"
                                                class="form-control hasdatetimepicker @error('treatment_start') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="treatment_start_error" class="error-msg-form"></span>

                                        @error('treatment_start')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.end') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_end" type="text"
                                                class="form-control hasdatetimepicker @error('treatment_end') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD">
                                        </div>
                                        <span id="treatment_end_error" class="error-msg-form"></span>

                                        @error('treatment_end')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                        <span class="next-form-steps text-gray-300 me-3 clickable-item-pointer"
                                            data-skip="true">Skip</span>
                                        <input type="button" name="next"
                                            class="next-form-steps btn btn-primary action-button-next"
                                            value="Continue" />
                                    </div>
                                </div>
                            </div>

                            <div class="cont_tap" id="medicines">

                                <div class="row mb-2">
                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.medicines') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-appo-patient select2-hidden-accessible @error('medicine_pills') is-invalid @enderror"
                                            multiple="" id="medicine_pills_appo" name="medicine_pills[]" required>
                                            @foreach ($medicine_cat as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name . ' - ' . $item->price . 'EGP' }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="medicine_pills_error" class="error-msg-form"></span>

                                        @error('medicine_pills')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.status') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="select2-no-search-appo-patient select2-hidden-accessible @error('medicine_status') is-invalid @enderror"
                                            id="medicine_status_appo" name="medicine_status" required>
                                            <option value="0">
                                                {{ __('patientappo.on medicine') }}
                                            </option>
                                            <option value="1">
                                                {{ __('patientappo.no result') }}
                                            </option>
                                            <option value="2">
                                                {{ __('patientappo.done') }}
                                            </option>
                                        </select>

                                        <span id="medicine_status_error" class="error-msg-form"></span>

                                        @error('medicine_status')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.start') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_start" type="text"
                                                class="form-control hasdatetimepicker @error('medicine_start') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="medicine_start_error" class="error-msg-form"></span>

                                        @error('medicine_start')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.end') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_end" type="text"
                                                class="form-control hasdatetimepicker @error('medicine_end') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>

                                        @error('medicine_end')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                        <span id="medicine_end_error" class="error-msg-form"></span>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                        <span class="next-form-steps text-gray-300 me-3 clickable-item-pointer"
                                            data-skip="true">Skip</span>
                                        <input type="button" name="next"
                                            class="next-form-steps btn btn-primary action-button-next"
                                            value="Continue" />
                                    </div>
                                </div>
                            </div>

                            <div class="cont_tap" id="session">
                                <div class="row mb-2">
                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('patientappo.session') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="myselect2-appo-patient select2-hidden-accessible @error('session_cat_service') is-invalid @enderror"
                                            id="session_cat_service" name="session_cat_service" required>
                                            @foreach ($service_cat_ses as $item)
                                            <option disabled selected> -- select Session -- </option>
                                            <option value="{{ $item->id }}" data-price="{{ $item->price }}">
                                                {{ $item->name . ' - ' . $item->price . 'EGP' }}
                                            </option>
                                            @endforeach
                                        </select>

                                        <span id="session_cat_service_error" class="error-msg-form"></span>

                                        @error('session_cat_service')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.status') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select
                                            class="select2-no-search-appo-patient select2-hidden-accessible @error('session_status') is-invalid @enderror"
                                            id="session_status_appo" name="session_status" required>
                                            <option value="0">
                                                {{ __('patientappo.not done') }}
                                            </option>
                                            <option value="1">
                                                {{ __('patientappo.done') }}
                                            </option>
                                        </select>

                                        <span id="session_status_error" class="error-msg-form"></span>

                                        @error('session_status')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('patientappo.related to treatment') }}
                                            <small>({{ __('basic.optional') }})</small></label>
                                        <select
                                            class="myselect2-appo-patient select2-hidden-accessible @error('related_treatment_id') is-invalid @enderror"
                                            id="related_treatment_id_appo" name="related_treatment_id">
                                            <option disabled selected> -- select treatment -- </option>
                                            @foreach ($patient->treatments as $item)
                                            @if ($item->status == 0)
                                            <option value="{{ $item->id }}">
                                                {{ $item->treatment_cat->name . ' - ' . $item->start }}
                                            </option>
                                            @endif
                                            @endforeach
                                        </select>

                                        <span id="related_treatment_id_error" class="error-msg-form"></span>

                                        @error('related_treatment_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('basic.date') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="session_date" type="text"
                                                class="form-control hasdatetimepicker @error('session_date') is-invalid @enderror"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="session_date_error" class="error-msg-form"></span>

                                        @error('session_date')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <hr class="mt-2">

                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <label class="form-label">{{ __('basic.final note appointment') }}
                                                <small>({{ __('basic.optional') }})</small></label>
                                            <textarea name="appo_note" class="form-control "
                                                placeholder="Write here the appointment note .." rows="4"
                                                spellcheck="false"></textarea>
                                            <span id="appo_note_lab_error" class="error-msg-form"></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                        <input type="submit" name="next" style=""
                                            class="next-form-steps btn text-gray-300 btn-default" data-skip="true"
                                            value="Send Without Session" />
                                        <input type="submit" name="next"
                                            class="next-form-steps btn btn-primary action-button-next" value="Send" />
                                    </div>
                                </div>
                            </div>

                            <div class="cont_tap" id="sending">
                                <div class="d-flex justify-content-center p2">
                                    <img src="{{ URL::asset('img/dashboard/system/loading-dash.svg') }}"
                                        style="width: 195px;" alt="Loading" />
                                </div>
                            </div>

                        </form>
                    </div>


                </div>

            </div>
        </div>

    </div>

    <!-- get all related info appointment -->
    <div class="modal fade" id="all_info_appointment" tabindex="-1" role="dialog" aria-labelledby="all_info_appointment"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                        {{ __('patientappo.last appointment') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-3 py-3 pt-1 pb-4">

                    <div class="multi-setps-form-calander col-12">

                        <form id="myform" method="POST"
                            action="{{ route('sett.pat_add_all_pt_info_appo', $patient->id) }}"
                            enctype="multipart/form-data">
                            @csrf

                            <!-- progressbar -->
                            <ul class="ps-0 progressbar_5icons progressbar" id="progressbar_patient">
                                <li class="active">
                                    <a>
                                        <!-- in case we want to use prog selector href="#clinics" -->
                                        <div
                                            class="icon-circle checked d-flex align-items-center justify-content-center">
                                            <i class="bi bi-calendar-range"></i>
                                        </div>
                                        <span>{{ __('basic.appointment') }}aa</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-stethoscope"></i>
                                        </div>
                                        <span>{{ __('basic.examination') }}</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-file-medical"></i>
                                        </div>
                                        <span>{{ __('basic.treatment') }}</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-capsules"></i>
                                        </div>
                                        <span>{{ __('basic.medicines') }}</span>
                                    </a>
                                </li>

                                <li>
                                    <a>
                                        <div class="icon-circle d-flex align-items-center justify-content-center">
                                            <i class="fas fa-vial"></i>
                                        </div>
                                        <span>{{ __('patientappo.sessions') }}</span>
                                    </a>
                                </li>
                            </ul>

                            <!-- content -->

                            <div class="cont_tap_patient" id="all_info_basic">

                                <div class="row">
                                    <div class="col-6 border-flex">
                                        <p class="text-gray-500 mb-2">Basic Info</p>
                                        <div class="mb-2">
                                            <h6 class="text-gray-300 text-s mb-1">Appointment start</h6>
                                            <p class="text-gray-600 text-s fw-bold" id="start_appo_all_info">
                                            </p>
                                        </div>
                                        <div class="mb-2">
                                            <h6 class="text-gray-300 text-s mb-1">Appointment End</h6>
                                            <p class="text-gray-600 text-s fw-bold" id="end_appo_all_info">
                                            </p>
                                        </div>
                                        <div class="mb-2">
                                            <h6 class="text-gray-300 text-s mb-1">Branch</h6>
                                            <p class="text-gray-600 text-s fw-bold" id="branch_appo_all_info">
                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="mb-2">
                                            <h6 class="text-gray-300 text-s mb-1">Responsible doctor</h6>
                                            <p class="text-gray-600 text-s fw-bold" id="respdoctor_appo_all_info">
                                            </p>
                                        </div>
                                        <div class="">
                                            <label class="form-label">Note</label>
                                            <div class="form-control-textarea overflow-auto" id="note_appo_all_info">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <div></div>
                                    <div>
                                        <input type="button" name="next"
                                            class="next-form-steps_patient btn btn-primary action-button-next"
                                            value="Continue" />
                                    </div>
                                </div>

                            </div>

                            <div class="cont_tap_patient px-2 px-md-3" id="all_info_examination">

                                <div class="row">

                                    <div class="d-flex justify-content-center mb-3 flex-wrap">

                                        <div class="d-flex justify-content-center flex-wrap me-0 me-md-5 mb-3 mb-xl-0">

                                            <div id="exam-front" class="mb-3 mb-md-0"
                                                style="background-image: url('{{ asset('img/dashboard/system/human_front.jpg') }}'); width:255px; height:457px; position: relative;">

                                            </div>

                                            <div id="exam-back" class="mb-3 mb-md-0"
                                                style="background-image: url('{{ asset('img/dashboard/system/human_back.jpg') }}'); width:255px; height:457px; position: relative;">

                                            </div>

                                        </div>

                                        <div
                                            class="d-flex d-xl-block p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center">
                                            <h5 class="mb-3 text-white me-2 me-xl-0"><i
                                                    class="far fa-question-circle"></i>
                                                {{ __('patientappo.last examination info') }}</h5>

                                            <div class="">
                                                <div class="mb-2 me-3 me-xl-5">
                                                    <label class="form-label text-blue-300 mb-1">{{
                                                        __('patientappo.examination note') }}:</label>
                                                    <div id="exam-note"
                                                        class="form-control-textarea overflow-auto text-white"
                                                        style="width: 241px; border-radius: 13px !important; border: 1px solid #6fa2ea;">

                                                    </div>
                                                </div>
                                                <div class="mb-2 me-3 me-xl-5">
                                                    <label class="form-label text-blue-300 mb-1">{{
                                                        __('patientappo.appointment date') }}:</label>
                                                    <div id="exam-date" class="text-white">

                                                    </div>
                                                </div>
                                                <div class="mb-2">
                                                    <label class="form-label text-blue-300 mb-1">{{ __('basic.doctor')
                                                        }}:</label>
                                                    <div id="exam-doctor" class="text-white">


                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <h5 class="mb-3 text-gray-400"><i class="far fa-question-circle"></i>
                                        Initial Examination</h5>

                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-disease-exam"
                                            width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs w-25">{{ __('basic.name') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.start') }}
                                                    </th>
                                                    <th class="text-xs text-center">{{ __('basic.end') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.status') }}
                                                    </th>
                                                    <th class="text-xs text-center">{{ __('basic.handle') }}
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody id="exam-table">
                                                <!-- it is sent by ajax -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                        <input type="button" name="next"
                                            class="next-form-steps_patient btn btn-primary action-button-next"
                                            value="Continue" />
                                    </div>
                                </div>
                            </div>

                            <div class="cont_tap_patient" id="all_info_treatment">

                                <div class="row">
                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-treatment" width="100%"
                                            cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs">{{ __('basic.id') }}</th>
                                                    <th class="text-xs">{{ __('basic.name') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.start') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.end') }}</th>
                                                    <th class="text-xs text-center">
                                                        {{ __('patientappo.sessions') }}
                                                    </th>
                                                    <th class="text-xs text-center">
                                                        {{ __('patientappo.sessions done') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.status') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.handle') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody id="treatment-table">
                                                <!-- it is sent by ajax -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                        <input type="button" name="next"
                                            class="next-form-steps_patient btn btn-primary action-button-next"
                                            value="Continue" />
                                    </div>
                                </div>
                            </div>

                            <div class="cont_tap_patient" id="all_info_medicines">

                                <div class="row">

                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-medicine" width="100%"
                                            cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs w-25">{{ __('basic.name') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.start') }}
                                                    </th>
                                                    <th class="text-xs text-center">{{ __('basic.end') }}</th>
                                                    <th class="text-xs text-center">{{ __('basic.status') }}
                                                    </th>
                                                    <th class="text-xs text-center">{{ __('basic.handle') }}
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody id="medic-table">
                                                <!-- it is sent by ajax -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                        <input type="button" name="next"
                                            class="next-form-steps_patient btn btn-primary action-button-next"
                                            value="Continue" />
                                    </div>
                                </div>
                            </div>

                            <div class="cont_tap_patient" id="all_info_session">

                                <div class="row">
                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-session" width="100%"
                                            cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs">{{ __('basic.name') }}</th>
                                                    <th class="text-xs text-center">
                                                        {{ __('patientappo.session status') }}</th>
                                                    <th class="text-xs text-center">
                                                        {{ __('patientappo.pay status') }}
                                                    </th>
                                                    <th class="text-xs text-center">
                                                        {{ __('patientappo.pay Code') }}
                                                    </th>
                                                    <th class="text-xs text-center">{{ __('basic.handle') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody id="session-table">
                                                <!-- it is sent by ajax -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between mt-3 align-items-center">
                                    <input type="button" name="previous"
                                        class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                        value="Previous" />
                                    <div>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>


                </div>

            </div>
        </div>

    </div> <!-- end of all info appointment -->




    <!-- appointment Modal delete -->
    <div class="modal fade" id="appointment_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form action="{{ route('sett.appointment.destroy', 'test') }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                appointment?</p><br>
                            <input type="hidden" name="appointment_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

</div>