<?php

namespace App\Models\Branch\Inventory;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Inventory_item_record extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'responsible_id',
        'type', //0=add, 1=withdraw
        'item_id',
        'invoice_id',
        'quantity',
        'price',
        'buying_date',
        'expirationـdate',
    ];   
    
    public function responsible()
    {
        return $this->belongsTo(User::class, 'responsible_id', 'id');
    }

    public function item()
    {
        return $this->belongsTo(Inventory_item::class, 'item_id', 'id');
    }


}