<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Http\Requests\PatientRequest;
use App\Http\Services\smsGateways\Victorylink;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Lab;
use App\Models\Branch\Oper_placecat;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\Invoice\Patient_wallet;
use App\Models\location\City;
use App\Models\location\Country;
use App\Models\Patient\Ask_for_cat;
use App\Models\Patient\Ask_for_main_cat;
use App\Models\Patient\Dental\Dent_main_cat;
use App\Models\Patient\Dental\Pat_bs_den_chart;
use App\Models\Patient\Disease;
use App\Models\Patient\Disease_cat;
use App\Models\Patient\Disease_draw;
use App\Models\Patient\From_recourse;
use App\Models\Patient\Medicine;
use App\Models\Patient\Medicine_cat;
use App\Models\Patient\Patient;
use App\Models\Patient\Pulse;
use App\Models\Patient\Pulse_area_cat;
use App\Models\Patient\Service_item;
use App\Models\Patient\Session_pat;
use App\Models\Patient\Specialty_cat;
use App\Models\Patient\Treatment;
use App\Models\Patient\Treatment_cat;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Validation\Rule;
use Mpdf\Mpdf;
use Mpdf\Tag\Input;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
use Image;


class Patient_dentalController extends Controller
{

    public function __construct()
    {

        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center')->only('index');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center')->only('show');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center')->only('create');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center')->only('store');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist')->only('update');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist')->only('edit');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    //for select input ajax to send the cities beasd on the given country
    public function createcityajax($id)
    {
        return City::where('country_id', $id)->get();
    }


    //for select input ajax to send the cities beasd on the given country
    public function create_askfor_ajax($id)
    {
        return Ask_for_cat::where('ask_for_main_cat_id', $id)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PatientRequest $request)
    {

        //insert img
        if ($request->hasFile('avatar')) {
            $file_extension = request()->avatar->getClientOriginalExtension();
            $file_name = $request->input('first_name') . time() . '.' . $file_extension;
            $path = 'img/useravatar';
            $request->avatar->move($path, $file_name);
        } else {
            $file_name = 'default-pp.png';
        };

        $user = Patient::create([
            'code' => "PA" . $this->generateRandomString(6),
            'type' => $request->input('status'),
            'ask_for_main_id' => $request->input('ask_for_main_id'),
            'ask_for_id' => $request->input('ask_for_id'),
            'email' => $request->input('email'),
            'password' => bcrypt($request->input('password')),
            'first_branch_id' => $request->input('first_branch_id'),
            'first_name' => $request->input('first_name'),
            'second_name' => $request->input('second_name'),
            'mother_name' => $request->input('mother_name'),
            'avatar' => $file_name,
            'birthday' => $request->input('birthday'),
            'gendar' => $request->input('gendar'),
            'country_id' => $request->input('country_id'),
            'city_id' => $request->input('city_id'),
            'phone_number' => $request->input('phone_number'),
            'sec_phone_number' => $request->input('sec_phone_number'),
            'insurance' => $request->input('insurance'),
            'from_recourse_id' => $request->input('from_recourse_id'),
            'height' => $request->input('height'),
            'weight' => $request->input('weight'),
            'blood_type' => $request->input('blood_type'),
            'note' => $request->input('note'),
            'creator_id' => Auth::id(),
        ]);

        session()->flash('success', 'The patient has been created successfully');
        return redirect()->route('sett.patient.show', $user->id);
    }

    public function show($id)
    {

        //for getting the last draw examination
        $appo_last_ex = Disease_draw::select('id', 'calendable_id')
            ->whereHas('appointment')
            ->where('calendable_type', 'App\Models\Branch\Appointment')
            ->where('patient_id', $id)
            ->orderBy('id', 'DESC')
            ->first();

        if ($appo_last_ex) {
            $appo_last_ex_id = $appo_last_ex->calendable_id;
        } else {
            $appo_last_ex_id = '';
        }

        $patient = Patient::with(['country' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            //----- appointments -----
            ->with(['appointments' => function ($q) {
                $q->select('id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'end_at', 'note_doctor', 'status')
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- invoices -----
            ->with(['invoices' => function ($q) {
                $q->select('id', 'type', 'service_inv_cat_id', 'code', 'operation', 'receivable_id', 'branch_id', 'discount', 'final_price', 'status', 'note', 'paid_date')
                    ->with(['invoice_items' => function ($q) {
                        $q->select('id', 'categorizable_id')
                            ->with(['categorizable' => function ($q) {
                                $q->select('id', 'name');
                            }]);
                    }])
                    ->with(['service_inv_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- wallet -----
            ->with(['wallet_reco' => function ($q) {
                $q->select('id', 'type', 'branch_id', 'patient_id', 'service_item_id', 'balance_before_tran', 'amount', 'date', 'note')
                    ->with(['service' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            //----- diseases -----
            ->with(['diseases' => function ($q) use ($appo_last_ex_id) {
                $q->select('id', 'disease_cats', 'calendable_type', 'calendable_id', 'patient_id', 'start', 'end', 'status')
                    ->where('calendable_id', $appo_last_ex_id)
                    ->where('calendable_type', 'App\Models\Branch\Appointment')
                    ->with(['diseasecats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['appointment' => function ($q) {
                        $q->select('id', 'start_at');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            ->with(['disease_draws' => function ($q) use ($appo_last_ex_id) {
                $q->select('id', 'type', 'calendable_type', 'calendable_id', 'patient_id', 'front', 'back',  'note')
                    ->where('calendable_id', $appo_last_ex_id)
                    ->where('calendable_type', 'App\Models\Branch\Appointment')
                    ->with(['appointment' => function ($q) {
                        $q->select('id', 'start_at', 'doctor_id')
                            ->with(['doctor' => function ($q) {
                                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                            }]);
                    }])
                    ->orderBy('id', 'DESC')
                    ->first();;
            }])
            //----- medicines -----
            ->with(['medicines' => function ($q) {
                $q->select('id', 'medicines_cats', 'patient_id', 'start', 'end', 'status')
                    ->with(['medicinescats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- treatments -----
            ->with(['treatments' => function ($q) {
                $q->select('id', 'patient_id', 'treatment_cat_id', 'sessions', 'sessions_done', 'start', 'end', 'status')
                    ->with(['treatment_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- sessions -----
            ->with(['sessions' => function ($q) {
                $q->select('id', 'patient_id', 'services_cat_id', 'treatment_id', 'status', 'date')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['treatment' => function ($q) {
                        $q->select('id', 'sessions');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- pulses -----
            ->with(['pulses' => function ($q) {
                $q->select('id', 'patient_id', 'services_cat_id', 'pulses_machine_id', 'appointment_id', 'doctor_id', 'branch_id', 'type', 'fluence', 'pulse_area_id', 'spot_size', 'balance_before_session', 'used_pulses', 'package_id', 'date')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['pulse_area' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['machine' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['package' => function ($q) {
                        $q->with(['service_item' => function ($q) {
                            $q->select('id', 'name');
                        }]);
                    }])
                    ->orderBy('date', 'ASC');
            }])
            //----- package -----
            ->with(['package' => function ($q) {
                $q->with(['service_item' => function ($q) {
                    $q->select('id', 'name');
                }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('date', 'ASC');
            }])

            //----- lab -----
            ->with(['labs' => function ($q) {
                $q->select('id', 'code', 'patient_id', 'services_cat_id', 'resp_doctor_id', 'xray_file', 'status', 'note_lab', 'created_at')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- operation -----   
            ->with(['operations' => function ($q) {
                $q->select('id', 'oper_place_id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'note', 'status', 'improvement_rate', 'note_after_op')
                    ->with(['place' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['pre_op_draw' => function ($q) {
                        $q->select('id', 'type', 'calendable_type', 'calendable_id', 'patient_id', 'front', 'back',  'note');
                    }])
                    ->with(['during_op' => function ($q) {;
                    }])
                    ->with(['diseases' => function ($q) {
                        $q->select('id', 'disease_cats', 'calendable_type', 'calendable_id', 'patient_id', 'start', 'end',  'status', 'created_at')
                            ->with(['diseasecats' => function ($q) {
                                $q->select('id', 'name');
                            }]);
                    }])
                    ->with(['gallery' => function ($q) {
                        $q->select('id', 'op_id', 'type', 'img');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])
            ->find($id);

        $disease_cat = Disease_cat::all();
        $medicine_cat = Medicine_cat::all();
        $treatment_cat = Treatment_cat::all();

        $service_cat_ses = Service_item::where('service_inv_cat_id', 2)
            ->where('deactivate', 0);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_ses = $service_cat_ses->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_ses = $service_cat_ses->get();

        $service_cat_pulses = Service_item::where('service_inv_cat_id', 3);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_pulses = $service_cat_pulses->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_pulses = $service_cat_pulses->get();


        $service_cat_lab = Service_item::where('service_inv_cat_id', 4);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_lab = $service_cat_lab->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_lab =  $service_cat_lab->get();

        $service_cat_oper = Service_item::where('service_inv_cat_id', 5);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_oper = $service_cat_oper->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_oper =  $service_cat_oper->get();

        $operation_place = Oper_placecat::select('id', 'name')->get();
        $pulses_area = Pulse_area_cat::all();

        $branches = Branch::all();

        $doctors = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'doctor');
                }
            )
            ->get();

        return view('patient.show_dental', compact('patient', 'disease_cat', 'medicine_cat', 'treatment_cat', 'service_cat_ses', 'service_cat_pulses', 'service_cat_lab', 'service_cat_oper', 'pulses_area', 'operation_place', 'branches', 'doctors'));
    }

    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function note_ajax(Request $request, $id)
    {

        $patient = Patient::find($id);

        $patient->note = $request->input('query');

        $patient->save();
    }



    public function store_basic_dental(Request $request)
    {

        $this->validate($request, [
            'patient_id' => 'required|exists:patients,id',
            'dent_main_cat_id' => 'required|exists:dent_main_cats,name',
            'services_cat_id' => 'required|exists:service_items,id',
            'tooth' => 'required',
            'surface' => 'required',
            'note' => 'max:255',
        ]);

        $dent_main_cat = Dent_main_cat::select('id')->where('name', $request->input('dent_main_cat_id'))->first();
        $service = Service_item::select('name')->find($request->input('services_cat_id'));

        $chart = Pat_bs_den_chart::create([
            'patient_id' => $request->input('patient_id'),
            'dent_main_cat_id' => $dent_main_cat->id,
            'services_cat_id' => $request->input('services_cat_id'),
            'tooth' => $request->input('tooth'),
            'surface' => json_encode($request->input('surface')),
            'doctor_id' => Auth::id(),
            'note' => $request->input('note'),
        ]);

        if ($chart) {
            return response()->json([
                "status" => true,
                "id" => $chart->id,
                "main_cat" => $request->input('dent_main_cat_id'),
                "service_name" => $service->name,
                "tooth" => $request->input('tooth'),
                'surface' => $request->input('surface'),
                "doctor_name" => Auth::user()->first_name,
                'note' => $request->input('note'),
                'date' => date('d M Y', strtotime($chart->created_at)),
            ]);
        } else {
            return response()->json([
                "status" => false,
            ]);
        }
    }


    public function store_action_dental(Request $request)
    {

        $this->validate($request, [
            'patient_id' => 'required|exists:patients,id',
            'dent_main_cat_id' => 'required|exists:dent_main_cats,name',
            'services_cat_id' => 'required|exists:service_items,id',
            'tooth' => 'required',
            'surface' => 'required',
            'note' => 'max:255',
            'last_appointment_id_dental' => ['required', 'exists:appointments,id'],
            'amount' => 'required',
        ]);

        $appo_branch = Appointment::select('branch_id')->find($request->input('last_appointment_id_dental'));

        $service_inv_cat = Service_item::select('id', 'price', 'service_inv_cat_id', 'doctor_comm')->where('id', $request->input('services_cat_id'))->first();

        if ($request->input('invoice_id') === 'new') {
            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'service_inv_cat_id' => $service_inv_cat->service_inv_cat_id,
                'specialty_id' => Auth::user()->specialty_id,
                'receivable_id' => $request->input('patient_id'),
                'receivable_type' => "App\Models\Patient\Patient",
                'branch_id' => $appo_branch->branch_id,
                'items_price' => $request->input('amount'),
                'final_price' => $request->input('amount'),
                'note' => $request->input('inv_note_dental'),
            ]);
            $invoice_id = $invoice->id;
            $invoice_code = $invoice->code;
        } elseif ($request->input('pulses_cat_invoice') === 'wallet') {
            $patient = Patient::select('wallet')->find($request->input('patient_id'));
            $wallet_reco = Patient_wallet::create([
                'type' => 1,
                'branch_id' => $appo_branch->branch_id,
                'patient_id' => $request->input('patient_id'),
                'service_item_id' =>  $request->input('services_cat_id'),
                'balance_before_tran' =>  $patient->wallet,
                'amount' => $request->input('amount'),
                'date' => Carbon::now(),
                'note' => $request->input('inv_note_dental'),
            ]);
            $invoice_id = "";
            $invoice_code = "";
        } else {
            $invoice_id = $request->input('invoice_id');
            $invoice_code = Invoice::select('code')->where('id', $invoice_id)->first();

            $invoice = Invoice::find($invoice_id);
            $invoice->increment('items_price', $request->input('amount'));
            $invoice->increment('final_price', $request->input('amount'));
            $invoice->note = $invoice->note . ' ' . $request->input('inv_note_dental');
            $invoice->save();
        }

        $doctor_comm = $service_inv_cat->doctor_comm / 100 * $service_inv_cat->price;

        $dent_main_cat = Dent_main_cat::select('id')->where('name', $request->input('dent_main_cat_id'))->first();
        $service = Service_item::select('name')->find($request->input('services_cat_id'));

        //create sessions for patient
        $session = Session_pat::create([
            'dent_main_cat_id' => $dent_main_cat->id,
            'services_cat_id' => $request->input('services_cat_id'),
            'appointment_id' => $request->input('last_appointment_id_dental'),
            'doctor_id' => Auth::id(),
            'patient_id' => $request->input('patient_id'),
            'tooth' => $request->input('tooth'),
            'surface' => json_encode($request->input('surface')),
            'status' => 0,
            'date' =>  Carbon::now(),
            'note' => $request->input('note'),
        ]);

        $invoice_item = Invoice_item::create([
            'invoice_id' => $invoice_id,
            'itemable_id' => $session->id,
            'itemable_type' => "App\Models\Patient\Session_pat",
            'categorizable_id' => $request->input('services_cat_id'),
            'categorizable_type' => "App\Models\Patient\Service_item",
            'price' => $request->input('amount'),
            'sold_price' => $request->input('amount'),
            'doctor_id' => Auth::id(),
            'doctor_comm' => $doctor_comm,
        ]);

        if ($session) {
            return response()->json([
                "status" => true,
                "id" => $session->id,
                "main_cat" => $request->input('dent_main_cat_id'),
                "service_name" => $service->name,
                "tooth" => $request->input('tooth'),
                'surface' => $request->input('surface'),
                "doctor_name" => Auth::user()->first_name,
                'amount' => $request->input('amount'),
                'invoice_id' => $invoice_id,
                'invoice_code' => $invoice_code,
                'note' => $request->input('note'),
                'date' => date('d M Y', strtotime($session->created_at)),
            ]);
        } else {
            return response()->json([
                "status" => false,
            ]);
        }
    }



    //for select input ajax to send the dental service beasd on the given main dental cat
    public function fetch_dental_service($name)
    {
        $main_cat = Dent_main_cat::select('id')->where('name', $name)->first();
        return Service_item::select('id', 'name', 'price')->where('dent_main_cat_id', $main_cat->id)->get();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function delete_basic_dental(Request $request)
    {

        Pat_bs_den_chart::find($request->input('id'))->delete();

        return response()->json([
            "status" => true,
        ]);
    }

    public function delete_action_dental(Request $request)
    {

        $session = Session_pat::find($request->input('id'));
        $amount = $session->service_item->sold_price;
        $invoice = Invoice::find($session->invoice_item->invoice_id);

        if (count($invoice->invoice_items) > 1) {
            $session->invoice_item->delete();
            $session->delete();
            $invoice->increment('items_price', $amount);
            $invoice->increment('final_price', $amount);
            $invoice->save();
        } else {
            $session->invoice_item->delete();
            $session->delete();
            $invoice->delete();
        }

        return response()->json([
            "status" => true,
        ]);
    }

    public function status_action_dental(Request $request)
    {

        $session = Session_pat::find($request->input('id'));

        if ($session->status == 0) {
            $status = 1;
            $msg = "The Item Has been Completed Successfully";
        } else {
            $status = 0;
            $msg = "The Item Has been Uncompleted Successfully";
        }

        $session->status = $status;
        $session->save();

        return response()->json([
            "status" => $status,
            "msg" => $msg,
        ]);
    }
}
