<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\Disease_cat;
use Illuminate\Http\Request;

class Examination_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $examination = Disease_cat::all();
        return view('cats/examinationcat.index', compact('examination'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/examinationcat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:disease_cats,name',
        ]);
        
        $examination = Disease_cat::create([  
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.examinationcat.index')
            ->with('success', 'Examination has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $examination = Disease_cat::find($id);
        return view('cats/examinationcat.edit', compact('examination'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $examination = Disease_cat::find($id);
        $examination->name = $request->input('name');
        $examination->save();

        return redirect()->route('sett.examinationcat.index')
            ->with('success', 'Examination has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}