<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class PulsesPulseAreasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pulse_pulses_areas', function (Blueprint $table) {
            $table->id();
            $table->integer('pulse_id');
            $table->integer('pulse_area_id');
            $table->foreign('pulse_id')->references('id')
                 ->on('pulses');
            $table->foreign('pulse_area_id')->references('id')
                ->on('pulse_area_cats');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pulse_pulses_areas');
    }
}
